/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdClient;
import software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse;
import software.amazon.awssdk.services.voiceid.model.SpeakerSummary;

public class ListSpeakersIterable
implements SdkIterable<ListSpeakersResponse> {
    private final VoiceIdClient client;
    private final ListSpeakersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSpeakersIterable(VoiceIdClient client, ListSpeakersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSpeakersResponseFetcher();
    }

    public Iterator<ListSpeakersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpeakerSummary> speakerSummaries() {
        Function<ListSpeakersResponse, Iterator> getIterator = response -> {
            if (response != null && response.speakerSummaries() != null) {
                return response.speakerSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSpeakersResponseFetcher
    implements SyncPageFetcher<ListSpeakersResponse> {
        private ListSpeakersResponseFetcher() {
        }

        public boolean hasNextPage(ListSpeakersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSpeakersResponse nextPage(ListSpeakersResponse previousPage) {
            if (previousPage == null) {
                return ListSpeakersIterable.this.client.listSpeakers(ListSpeakersIterable.this.firstRequest);
            }
            return ListSpeakersIterable.this.client.listSpeakers((ListSpeakersRequest)((Object)ListSpeakersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

