/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdAsyncClient;
import software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobSummary;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse;

public class ListFraudsterRegistrationJobsPublisher
implements SdkPublisher<ListFraudsterRegistrationJobsResponse> {
    private final VoiceIdAsyncClient client;
    private final ListFraudsterRegistrationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFraudsterRegistrationJobsPublisher(VoiceIdAsyncClient client, ListFraudsterRegistrationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFraudsterRegistrationJobsPublisher(VoiceIdAsyncClient client, ListFraudsterRegistrationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFraudsterRegistrationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFraudsterRegistrationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FraudsterRegistrationJobSummary> jobSummaries() {
        Function<ListFraudsterRegistrationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFraudsterRegistrationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFraudsterRegistrationJobsResponseFetcher
    implements AsyncPageFetcher<ListFraudsterRegistrationJobsResponse> {
        private ListFraudsterRegistrationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListFraudsterRegistrationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFraudsterRegistrationJobsResponse> nextPage(ListFraudsterRegistrationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListFraudsterRegistrationJobsPublisher.this.client.listFraudsterRegistrationJobs(ListFraudsterRegistrationJobsPublisher.this.firstRequest);
            }
            return ListFraudsterRegistrationJobsPublisher.this.client.listFraudsterRegistrationJobs((ListFraudsterRegistrationJobsRequest)((Object)ListFraudsterRegistrationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

