/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.SpeakerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpeakerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpeakerSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(SpeakerSummary.getter(SpeakerSummary::createdAt)).setter(SpeakerSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> CUSTOMER_SPEAKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerSpeakerId").getter(SpeakerSummary.getter(SpeakerSummary::customerSpeakerId)).setter(SpeakerSummary.setter(Builder::customerSpeakerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerSpeakerId").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(SpeakerSummary.getter(SpeakerSummary::domainId)).setter(SpeakerSummary.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> GENERATED_SPEAKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedSpeakerId").getter(SpeakerSummary.getter(SpeakerSummary::generatedSpeakerId)).setter(SpeakerSummary.setter(Builder::generatedSpeakerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedSpeakerId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SpeakerSummary.getter(SpeakerSummary::statusAsString)).setter(SpeakerSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(SpeakerSummary.getter(SpeakerSummary::updatedAt)).setter(SpeakerSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CUSTOMER_SPEAKER_ID_FIELD, DOMAIN_ID_FIELD, GENERATED_SPEAKER_ID_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String customerSpeakerId;
    private final String domainId;
    private final String generatedSpeakerId;
    private final String status;
    private final Instant updatedAt;

    private SpeakerSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.customerSpeakerId = builder.customerSpeakerId;
        this.domainId = builder.domainId;
        this.generatedSpeakerId = builder.generatedSpeakerId;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String customerSpeakerId() {
        return this.customerSpeakerId;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String generatedSpeakerId() {
        return this.generatedSpeakerId;
    }

    public final SpeakerStatus status() {
        return SpeakerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeakerSummary)) {
            return false;
        }
        SpeakerSummary other = (SpeakerSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.customerSpeakerId(), other.customerSpeakerId()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.generatedSpeakerId(), other.generatedSpeakerId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"SpeakerSummary").add("CreatedAt", (Object)this.createdAt()).add("CustomerSpeakerId", (Object)(this.customerSpeakerId() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("GeneratedSpeakerId", (Object)this.generatedSpeakerId()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CustomerSpeakerId": {
                return Optional.ofNullable(clazz.cast(this.customerSpeakerId()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "GeneratedSpeakerId": {
                return Optional.ofNullable(clazz.cast(this.generatedSpeakerId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpeakerSummary, T> g) {
        return obj -> g.apply((SpeakerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String customerSpeakerId;
        private String domainId;
        private String generatedSpeakerId;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeakerSummary model) {
            this.createdAt(model.createdAt);
            this.customerSpeakerId(model.customerSpeakerId);
            this.domainId(model.domainId);
            this.generatedSpeakerId(model.generatedSpeakerId);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCustomerSpeakerId() {
            return this.customerSpeakerId;
        }

        public final void setCustomerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
        }

        @Override
        @Transient
        public final Builder customerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        @Transient
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGeneratedSpeakerId() {
            return this.generatedSpeakerId;
        }

        public final void setGeneratedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
        }

        @Override
        @Transient
        public final Builder generatedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(SpeakerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SpeakerSummary build() {
            return new SpeakerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpeakerSummary> {
        public Builder createdAt(Instant var1);

        public Builder customerSpeakerId(String var1);

        public Builder domainId(String var1);

        public Builder generatedSpeakerId(String var1);

        public Builder status(String var1);

        public Builder status(SpeakerStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

