/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePolicyTemplateRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<UpdatePolicyTemplateRequest.Builder, UpdatePolicyTemplateRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(UpdatePolicyTemplateRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> POLICY_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyTemplateId").getter(getter(UpdatePolicyTemplateRequest::policyTemplateId))
            .setter(setter(Builder::policyTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplateId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdatePolicyTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statement").getter(getter(UpdatePolicyTemplateRequest::statement)).setter(setter(Builder::statement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            POLICY_TEMPLATE_ID_FIELD, DESCRIPTION_FIELD, STATEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyStoreId;

    private final String policyTemplateId;

    private final String description;

    private final String statement;

    private UpdatePolicyTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.policyTemplateId = builder.policyTemplateId;
        this.description = builder.description;
        this.statement = builder.statement;
    }

    /**
     * <p>
     * Specifies the ID of the policy store that contains the policy template that you want to update.
     * </p>
     * 
     * @return Specifies the ID of the policy store that contains the policy template that you want to update.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies the ID of the policy template that you want to update.
     * </p>
     * 
     * @return Specifies the ID of the policy template that you want to update.
     */
    public final String policyTemplateId() {
        return policyTemplateId;
    }

    /**
     * <p>
     * Specifies a new description to apply to the policy template.
     * </p>
     * 
     * @return Specifies a new description to apply to the policy template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies new statement content written in Cedar policy language to replace the current body of the policy
     * template.
     * </p>
     * <p>
     * You can change only the following elements of the policy body:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>action</code> referenced by the policy template.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You <b>can't</b> change the following elements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The effect (<code>permit</code> or <code>forbid</code>) of the policy template.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>principal</code> referenced by the policy template.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>resource</code> referenced by the policy template.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies new statement content written in Cedar policy language to replace the current body of the
     *         policy template.</p>
     *         <p>
     *         You can change only the following elements of the policy body:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>action</code> referenced by the policy template.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You <b>can't</b> change the following elements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The effect (<code>permit</code> or <code>forbid</code>) of the policy template.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>principal</code> referenced by the policy template.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>resource</code> referenced by the policy template.
     *         </p>
     *         </li>
     */
    public final String statement() {
        return statement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(policyTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicyTemplateRequest)) {
            return false;
        }
        UpdatePolicyTemplateRequest other = (UpdatePolicyTemplateRequest) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId())
                && Objects.equals(policyTemplateId(), other.policyTemplateId())
                && Objects.equals(description(), other.description()) && Objects.equals(statement(), other.statement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePolicyTemplateRequest").add("PolicyStoreId", policyStoreId())
                .add("PolicyTemplateId", policyTemplateId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Statement", statement() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "policyTemplateId":
            return Optional.ofNullable(clazz.cast(policyTemplateId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "statement":
            return Optional.ofNullable(clazz.cast(statement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("policyTemplateId", POLICY_TEMPLATE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("statement", STATEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePolicyTemplateRequest, T> g) {
        return obj -> g.apply((UpdatePolicyTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePolicyTemplateRequest> {
        /**
         * <p>
         * Specifies the ID of the policy store that contains the policy template that you want to update.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store that contains the policy template that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies the ID of the policy template that you want to update.
         * </p>
         * 
         * @param policyTemplateId
         *        Specifies the ID of the policy template that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTemplateId(String policyTemplateId);

        /**
         * <p>
         * Specifies a new description to apply to the policy template.
         * </p>
         * 
         * @param description
         *        Specifies a new description to apply to the policy template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies new statement content written in Cedar policy language to replace the current body of the policy
         * template.
         * </p>
         * <p>
         * You can change only the following elements of the policy body:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>action</code> referenced by the policy template.
         * </p>
         * </li>
         * <li>
         * <p>
         * Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You <b>can't</b> change the following elements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The effect (<code>permit</code> or <code>forbid</code>) of the policy template.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>principal</code> referenced by the policy template.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>resource</code> referenced by the policy template.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statement
         *        Specifies new statement content written in Cedar policy language to replace the current body of the
         *        policy template.</p>
         *        <p>
         *        You can change only the following elements of the policy body:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>action</code> referenced by the policy template.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You <b>can't</b> change the following elements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The effect (<code>permit</code> or <code>forbid</code>) of the policy template.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>principal</code> referenced by the policy template.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>resource</code> referenced by the policy template.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statement(String statement);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String policyStoreId;

        private String policyTemplateId;

        private String description;

        private String statement;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicyTemplateRequest model) {
            super(model);
            policyStoreId(model.policyStoreId);
            policyTemplateId(model.policyTemplateId);
            description(model.description);
            statement(model.statement);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyTemplateId() {
            return policyTemplateId;
        }

        public final void setPolicyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
        }

        @Override
        public final Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatement() {
            return statement;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePolicyTemplateRequest build() {
            return new UpdatePolicyTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
