/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The token type that you want to process from your OIDC identity provider. Your policy store can process either
 * identity (ID) or access tokens from a given OIDC identity source.
 * </p>
 * <p>
 * This data type is part of a <a href=
 * "https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectConfiguration.html"
 * >UpdateOpenIdConnectConfiguration</a> structure, which is a parameter to <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html"
 * >UpdateIdentitySource</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOpenIdConnectTokenSelection implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateOpenIdConnectTokenSelection.Builder, UpdateOpenIdConnectTokenSelection> {
    private static final SdkField<UpdateOpenIdConnectAccessTokenConfiguration> ACCESS_TOKEN_ONLY_FIELD = SdkField
            .<UpdateOpenIdConnectAccessTokenConfiguration> builder(MarshallingType.SDK_POJO).memberName("accessTokenOnly")
            .getter(getter(UpdateOpenIdConnectTokenSelection::accessTokenOnly)).setter(setter(Builder::accessTokenOnly))
            .constructor(UpdateOpenIdConnectAccessTokenConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTokenOnly").build()).build();

    private static final SdkField<UpdateOpenIdConnectIdentityTokenConfiguration> IDENTITY_TOKEN_ONLY_FIELD = SdkField
            .<UpdateOpenIdConnectIdentityTokenConfiguration> builder(MarshallingType.SDK_POJO).memberName("identityTokenOnly")
            .getter(getter(UpdateOpenIdConnectTokenSelection::identityTokenOnly)).setter(setter(Builder::identityTokenOnly))
            .constructor(UpdateOpenIdConnectIdentityTokenConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityTokenOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_ONLY_FIELD,
            IDENTITY_TOKEN_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateOpenIdConnectAccessTokenConfiguration accessTokenOnly;

    private final UpdateOpenIdConnectIdentityTokenConfiguration identityTokenOnly;

    private final Type type;

    private UpdateOpenIdConnectTokenSelection(BuilderImpl builder) {
        this.accessTokenOnly = builder.accessTokenOnly;
        this.identityTokenOnly = builder.identityTokenOnly;
        this.type = builder.type;
    }

    /**
     * <p>
     * The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
     * <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example
     * <code>sub</code>.
     * </p>
     * 
     * @return The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
     *         <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example
     *         <code>sub</code>.
     */
    public final UpdateOpenIdConnectAccessTokenConfiguration accessTokenOnly() {
        return accessTokenOnly;
    }

    /**
     * <p>
     * The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example
     * <code>1example23456789</code>, and the claim that you want to map to the principal, for example <code>sub</code>.
     * </p>
     * 
     * @return The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for
     *         example <code>1example23456789</code>, and the claim that you want to map to the principal, for example
     *         <code>sub</code>.
     */
    public final UpdateOpenIdConnectIdentityTokenConfiguration identityTokenOnly() {
        return identityTokenOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessTokenOnly());
        hashCode = 31 * hashCode + Objects.hashCode(identityTokenOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenIdConnectTokenSelection)) {
            return false;
        }
        UpdateOpenIdConnectTokenSelection other = (UpdateOpenIdConnectTokenSelection) obj;
        return Objects.equals(accessTokenOnly(), other.accessTokenOnly())
                && Objects.equals(identityTokenOnly(), other.identityTokenOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOpenIdConnectTokenSelection").add("AccessTokenOnly", accessTokenOnly())
                .add("IdentityTokenOnly", identityTokenOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessTokenOnly":
            return Optional.ofNullable(clazz.cast(accessTokenOnly()));
        case "identityTokenOnly":
            return Optional.ofNullable(clazz.cast(identityTokenOnly()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #accessTokenOnly()} initialized to the given value.
     *
     * <p>
     * The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
     * <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example
     * <code>sub</code>.
     * </p>
     * 
     * @param accessTokenOnly
     *        The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
     *        <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example
     *        <code>sub</code>.
     */
    public static UpdateOpenIdConnectTokenSelection fromAccessTokenOnly(
            UpdateOpenIdConnectAccessTokenConfiguration accessTokenOnly) {
        return builder().accessTokenOnly(accessTokenOnly).build();
    }

    /**
     * Create an instance of this class with {@link #accessTokenOnly()} initialized to the given value.
     *
     * <p>
     * The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
     * <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example
     * <code>sub</code>.
     * </p>
     * 
     * @param accessTokenOnly
     *        The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
     *        <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example
     *        <code>sub</code>.
     */
    public static UpdateOpenIdConnectTokenSelection fromAccessTokenOnly(
            Consumer<UpdateOpenIdConnectAccessTokenConfiguration.Builder> accessTokenOnly) {
        UpdateOpenIdConnectAccessTokenConfiguration.Builder builder = UpdateOpenIdConnectAccessTokenConfiguration.builder();
        accessTokenOnly.accept(builder);
        return fromAccessTokenOnly(builder.build());
    }

    /**
     * Create an instance of this class with {@link #identityTokenOnly()} initialized to the given value.
     *
     * <p>
     * The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example
     * <code>1example23456789</code>, and the claim that you want to map to the principal, for example <code>sub</code>.
     * </p>
     * 
     * @param identityTokenOnly
     *        The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example
     *        <code>1example23456789</code>, and the claim that you want to map to the principal, for example
     *        <code>sub</code>.
     */
    public static UpdateOpenIdConnectTokenSelection fromIdentityTokenOnly(
            UpdateOpenIdConnectIdentityTokenConfiguration identityTokenOnly) {
        return builder().identityTokenOnly(identityTokenOnly).build();
    }

    /**
     * Create an instance of this class with {@link #identityTokenOnly()} initialized to the given value.
     *
     * <p>
     * The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example
     * <code>1example23456789</code>, and the claim that you want to map to the principal, for example <code>sub</code>.
     * </p>
     * 
     * @param identityTokenOnly
     *        The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example
     *        <code>1example23456789</code>, and the claim that you want to map to the principal, for example
     *        <code>sub</code>.
     */
    public static UpdateOpenIdConnectTokenSelection fromIdentityTokenOnly(
            Consumer<UpdateOpenIdConnectIdentityTokenConfiguration.Builder> identityTokenOnly) {
        UpdateOpenIdConnectIdentityTokenConfiguration.Builder builder = UpdateOpenIdConnectIdentityTokenConfiguration.builder();
        identityTokenOnly.accept(builder);
        return fromIdentityTokenOnly(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessTokenOnly", ACCESS_TOKEN_ONLY_FIELD);
        map.put("identityTokenOnly", IDENTITY_TOKEN_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpenIdConnectTokenSelection, T> g) {
        return obj -> g.apply((UpdateOpenIdConnectTokenSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateOpenIdConnectTokenSelection> {
        /**
         * <p>
         * The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
         * <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example
         * <code>sub</code>.
         * </p>
         * 
         * @param accessTokenOnly
         *        The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
         *        <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for
         *        example <code>sub</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTokenOnly(UpdateOpenIdConnectAccessTokenConfiguration accessTokenOnly);

        /**
         * <p>
         * The OIDC configuration for processing access tokens. Contains allowed audience claims, for example
         * <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example
         * <code>sub</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateOpenIdConnectAccessTokenConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateOpenIdConnectAccessTokenConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateOpenIdConnectAccessTokenConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #accessTokenOnly(UpdateOpenIdConnectAccessTokenConfiguration)}.
         * 
         * @param accessTokenOnly
         *        a consumer that will call methods on {@link UpdateOpenIdConnectAccessTokenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessTokenOnly(UpdateOpenIdConnectAccessTokenConfiguration)
         */
        default Builder accessTokenOnly(Consumer<UpdateOpenIdConnectAccessTokenConfiguration.Builder> accessTokenOnly) {
            return accessTokenOnly(UpdateOpenIdConnectAccessTokenConfiguration.builder().applyMutation(accessTokenOnly).build());
        }

        /**
         * <p>
         * The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example
         * <code>1example23456789</code>, and the claim that you want to map to the principal, for example
         * <code>sub</code>.
         * </p>
         * 
         * @param identityTokenOnly
         *        The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for
         *        example <code>1example23456789</code>, and the claim that you want to map to the principal, for
         *        example <code>sub</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityTokenOnly(UpdateOpenIdConnectIdentityTokenConfiguration identityTokenOnly);

        /**
         * <p>
         * The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example
         * <code>1example23456789</code>, and the claim that you want to map to the principal, for example
         * <code>sub</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateOpenIdConnectIdentityTokenConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateOpenIdConnectIdentityTokenConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateOpenIdConnectIdentityTokenConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #identityTokenOnly(UpdateOpenIdConnectIdentityTokenConfiguration)}.
         * 
         * @param identityTokenOnly
         *        a consumer that will call methods on {@link UpdateOpenIdConnectIdentityTokenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityTokenOnly(UpdateOpenIdConnectIdentityTokenConfiguration)
         */
        default Builder identityTokenOnly(Consumer<UpdateOpenIdConnectIdentityTokenConfiguration.Builder> identityTokenOnly) {
            return identityTokenOnly(UpdateOpenIdConnectIdentityTokenConfiguration.builder().applyMutation(identityTokenOnly)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateOpenIdConnectAccessTokenConfiguration accessTokenOnly;

        private UpdateOpenIdConnectIdentityTokenConfiguration identityTokenOnly;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenIdConnectTokenSelection model) {
            accessTokenOnly(model.accessTokenOnly);
            identityTokenOnly(model.identityTokenOnly);
        }

        public final UpdateOpenIdConnectAccessTokenConfiguration.Builder getAccessTokenOnly() {
            return accessTokenOnly != null ? accessTokenOnly.toBuilder() : null;
        }

        public final void setAccessTokenOnly(UpdateOpenIdConnectAccessTokenConfiguration.BuilderImpl accessTokenOnly) {
            Object oldValue = this.accessTokenOnly;
            this.accessTokenOnly = accessTokenOnly != null ? accessTokenOnly.build() : null;
            handleUnionValueChange(Type.ACCESS_TOKEN_ONLY, oldValue, this.accessTokenOnly);
        }

        @Override
        public final Builder accessTokenOnly(UpdateOpenIdConnectAccessTokenConfiguration accessTokenOnly) {
            Object oldValue = this.accessTokenOnly;
            this.accessTokenOnly = accessTokenOnly;
            handleUnionValueChange(Type.ACCESS_TOKEN_ONLY, oldValue, this.accessTokenOnly);
            return this;
        }

        public final UpdateOpenIdConnectIdentityTokenConfiguration.Builder getIdentityTokenOnly() {
            return identityTokenOnly != null ? identityTokenOnly.toBuilder() : null;
        }

        public final void setIdentityTokenOnly(UpdateOpenIdConnectIdentityTokenConfiguration.BuilderImpl identityTokenOnly) {
            Object oldValue = this.identityTokenOnly;
            this.identityTokenOnly = identityTokenOnly != null ? identityTokenOnly.build() : null;
            handleUnionValueChange(Type.IDENTITY_TOKEN_ONLY, oldValue, this.identityTokenOnly);
        }

        @Override
        public final Builder identityTokenOnly(UpdateOpenIdConnectIdentityTokenConfiguration identityTokenOnly) {
            Object oldValue = this.identityTokenOnly;
            this.identityTokenOnly = identityTokenOnly;
            handleUnionValueChange(Type.IDENTITY_TOKEN_ONLY, oldValue, this.identityTokenOnly);
            return this;
        }

        @Override
        public UpdateOpenIdConnectTokenSelection build() {
            return new UpdateOpenIdConnectTokenSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UpdateOpenIdConnectTokenSelection#type()
     */
    public enum Type {
        ACCESS_TOKEN_ONLY,

        IDENTITY_TOKEN_ONLY,

        UNKNOWN_TO_SDK_VERSION
    }
}
