/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePolicyTemplateRequest
extends VerifiedPermissionsRequest
implements ToCopyableBuilder<Builder, UpdatePolicyTemplateRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(UpdatePolicyTemplateRequest.getter(UpdatePolicyTemplateRequest::policyStoreId)).setter(UpdatePolicyTemplateRequest.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> POLICY_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyTemplateId").getter(UpdatePolicyTemplateRequest.getter(UpdatePolicyTemplateRequest::policyTemplateId)).setter(UpdatePolicyTemplateRequest.setter(Builder::policyTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplateId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdatePolicyTemplateRequest.getter(UpdatePolicyTemplateRequest::description)).setter(UpdatePolicyTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statement").getter(UpdatePolicyTemplateRequest.getter(UpdatePolicyTemplateRequest::statement)).setter(UpdatePolicyTemplateRequest.setter(Builder::statement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, POLICY_TEMPLATE_ID_FIELD, DESCRIPTION_FIELD, STATEMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePolicyTemplateRequest.memberNameToFieldInitializer();
    private final String policyStoreId;
    private final String policyTemplateId;
    private final String description;
    private final String statement;

    private UpdatePolicyTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.policyTemplateId = builder.policyTemplateId;
        this.description = builder.description;
        this.statement = builder.statement;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String policyTemplateId() {
        return this.policyTemplateId;
    }

    public final String description() {
        return this.description;
    }

    public final String statement() {
        return this.statement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicyTemplateRequest)) {
            return false;
        }
        UpdatePolicyTemplateRequest other = (UpdatePolicyTemplateRequest)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.policyTemplateId(), other.policyTemplateId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statement(), other.statement());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePolicyTemplateRequest").add("PolicyStoreId", (Object)this.policyStoreId()).add("PolicyTemplateId", (Object)this.policyTemplateId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Statement", (Object)(this.statement() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "policyTemplateId": {
                return Optional.ofNullable(clazz.cast(this.policyTemplateId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "statement": {
                return Optional.ofNullable(clazz.cast(this.statement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("policyTemplateId", POLICY_TEMPLATE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("statement", STATEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePolicyTemplateRequest, T> g) {
        return obj -> g.apply((UpdatePolicyTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsRequest.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private String policyTemplateId;
        private String description;
        private String statement;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicyTemplateRequest model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.policyTemplateId(model.policyTemplateId);
            this.description(model.description);
            this.statement(model.statement);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyTemplateId() {
            return this.policyTemplateId;
        }

        public final void setPolicyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
        }

        @Override
        public final Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatement() {
            return this.statement;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePolicyTemplateRequest build() {
            return new UpdatePolicyTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePolicyTemplateRequest> {
        public Builder policyStoreId(String var1);

        public Builder policyTemplateId(String var1);

        public Builder description(String var1);

        public Builder statement(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

