/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.Configuration;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIdentitySourceRequest
extends VerifiedPermissionsRequest
implements ToCopyableBuilder<Builder, CreateIdentitySourceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateIdentitySourceRequest.getter(CreateIdentitySourceRequest::clientToken)).setter(CreateIdentitySourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(CreateIdentitySourceRequest.getter(CreateIdentitySourceRequest::policyStoreId)).setter(CreateIdentitySourceRequest.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<Configuration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateIdentitySourceRequest.getter(CreateIdentitySourceRequest::configuration)).setter(CreateIdentitySourceRequest.setter(Builder::configuration)).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> PRINCIPAL_ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalEntityType").getter(CreateIdentitySourceRequest.getter(CreateIdentitySourceRequest::principalEntityType)).setter(CreateIdentitySourceRequest.setter(Builder::principalEntityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalEntityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, POLICY_STORE_ID_FIELD, CONFIGURATION_FIELD, PRINCIPAL_ENTITY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("policyStoreId", POLICY_STORE_ID_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("principalEntityType", PRINCIPAL_ENTITY_TYPE_FIELD);
        }
    });
    private final String clientToken;
    private final String policyStoreId;
    private final Configuration configuration;
    private final String principalEntityType;

    private CreateIdentitySourceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.policyStoreId = builder.policyStoreId;
        this.configuration = builder.configuration;
        this.principalEntityType = builder.principalEntityType;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final Configuration configuration() {
        return this.configuration;
    }

    public final String principalEntityType() {
        return this.principalEntityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalEntityType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentitySourceRequest)) {
            return false;
        }
        CreateIdentitySourceRequest other = (CreateIdentitySourceRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.principalEntityType(), other.principalEntityType());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIdentitySourceRequest").add("ClientToken", (Object)this.clientToken()).add("PolicyStoreId", (Object)this.policyStoreId()).add("Configuration", (Object)this.configuration()).add("PrincipalEntityType", (Object)(this.principalEntityType() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "principalEntityType": {
                return Optional.ofNullable(clazz.cast(this.principalEntityType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateIdentitySourceRequest, T> g) {
        return obj -> g.apply((CreateIdentitySourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String policyStoreId;
        private Configuration configuration;
        private String principalEntityType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentitySourceRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.policyStoreId(model.policyStoreId);
            this.configuration(model.configuration);
            this.principalEntityType(model.principalEntityType);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final Configuration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(Configuration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getPrincipalEntityType() {
            return this.principalEntityType;
        }

        public final void setPrincipalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
        }

        @Override
        public final Builder principalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIdentitySourceRequest build() {
            return new CreateIdentitySourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIdentitySourceRequest> {
        public Builder clientToken(String var1);

        public Builder policyStoreId(String var1);

        public Builder configuration(Configuration var1);

        default public Builder configuration(Consumer<Configuration.Builder> configuration) {
            return this.configuration((Configuration)((Configuration.Builder)Configuration.builder().applyMutation(configuration)).build());
        }

        public Builder principalEntityType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

