/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The claim in OIDC identity provider tokens that indicates a user's group membership, and the entity type that you
 * want to map it to. For example, this object can map the contents of a <code>groups</code> claim to
 * <code>MyCorp::UserGroup</code>.
 * </p>
 * <p>
 * This data type is part of a <a href=
 * "https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectConfiguration.html"
 * >UpdateOpenIdConnectConfiguration</a> structure, which is a parameter to <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html"
 * >UpdateIdentitySource</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOpenIdConnectGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateOpenIdConnectGroupConfiguration.Builder, UpdateOpenIdConnectGroupConfiguration> {
    private static final SdkField<String> GROUP_CLAIM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupClaim").getter(getter(UpdateOpenIdConnectGroupConfiguration::groupClaim))
            .setter(setter(Builder::groupClaim))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupClaim").build()).build();

    private static final SdkField<String> GROUP_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupEntityType").getter(getter(UpdateOpenIdConnectGroupConfiguration::groupEntityType))
            .setter(setter(Builder::groupEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupEntityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_CLAIM_FIELD,
            GROUP_ENTITY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupClaim;

    private final String groupEntityType;

    private UpdateOpenIdConnectGroupConfiguration(BuilderImpl builder) {
        this.groupClaim = builder.groupClaim;
        this.groupEntityType = builder.groupEntityType;
    }

    /**
     * <p>
     * The token claim that you want Verified Permissions to interpret as group membership. For example,
     * <code>groups</code>.
     * </p>
     * 
     * @return The token claim that you want Verified Permissions to interpret as group membership. For example,
     *         <code>groups</code>.
     */
    public final String groupClaim() {
        return groupClaim;
    }

    /**
     * <p>
     * The policy store entity type that you want to map your users' group claim to. For example,
     * <code>MyCorp::UserGroup</code>. A group entity type is an entity that can have a user entity type as a member.
     * </p>
     * 
     * @return The policy store entity type that you want to map your users' group claim to. For example,
     *         <code>MyCorp::UserGroup</code>. A group entity type is an entity that can have a user entity type as a
     *         member.
     */
    public final String groupEntityType() {
        return groupEntityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupClaim());
        hashCode = 31 * hashCode + Objects.hashCode(groupEntityType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenIdConnectGroupConfiguration)) {
            return false;
        }
        UpdateOpenIdConnectGroupConfiguration other = (UpdateOpenIdConnectGroupConfiguration) obj;
        return Objects.equals(groupClaim(), other.groupClaim()) && Objects.equals(groupEntityType(), other.groupEntityType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOpenIdConnectGroupConfiguration")
                .add("GroupClaim", groupClaim() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GroupEntityType", groupEntityType() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupClaim":
            return Optional.ofNullable(clazz.cast(groupClaim()));
        case "groupEntityType":
            return Optional.ofNullable(clazz.cast(groupEntityType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpenIdConnectGroupConfiguration, T> g) {
        return obj -> g.apply((UpdateOpenIdConnectGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateOpenIdConnectGroupConfiguration> {
        /**
         * <p>
         * The token claim that you want Verified Permissions to interpret as group membership. For example,
         * <code>groups</code>.
         * </p>
         * 
         * @param groupClaim
         *        The token claim that you want Verified Permissions to interpret as group membership. For example,
         *        <code>groups</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupClaim(String groupClaim);

        /**
         * <p>
         * The policy store entity type that you want to map your users' group claim to. For example,
         * <code>MyCorp::UserGroup</code>. A group entity type is an entity that can have a user entity type as a
         * member.
         * </p>
         * 
         * @param groupEntityType
         *        The policy store entity type that you want to map your users' group claim to. For example,
         *        <code>MyCorp::UserGroup</code>. A group entity type is an entity that can have a user entity type as a
         *        member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupEntityType(String groupEntityType);
    }

    static final class BuilderImpl implements Builder {
        private String groupClaim;

        private String groupEntityType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenIdConnectGroupConfiguration model) {
            groupClaim(model.groupClaim);
            groupEntityType(model.groupEntityType);
        }

        public final String getGroupClaim() {
            return groupClaim;
        }

        public final void setGroupClaim(String groupClaim) {
            this.groupClaim = groupClaim;
        }

        @Override
        public final Builder groupClaim(String groupClaim) {
            this.groupClaim = groupClaim;
            return this;
        }

        public final String getGroupEntityType() {
            return groupEntityType;
        }

        public final void setGroupEntityType(String groupEntityType) {
            this.groupEntityType = groupEntityType;
        }

        @Override
        public final Builder groupEntityType(String groupEntityType) {
            this.groupEntityType = groupEntityType;
            return this;
        }

        @Override
        public UpdateOpenIdConnectGroupConfiguration build() {
            return new UpdateOpenIdConnectGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
