/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.ClientIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOpenIdConnectIdentityTokenConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateOpenIdConnectIdentityTokenConfiguration> {
    private static final SdkField<String> PRINCIPAL_ID_CLAIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalIdClaim").getter(UpdateOpenIdConnectIdentityTokenConfiguration.getter(UpdateOpenIdConnectIdentityTokenConfiguration::principalIdClaim)).setter(UpdateOpenIdConnectIdentityTokenConfiguration.setter(Builder::principalIdClaim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalIdClaim").build()}).build();
    private static final SdkField<List<String>> CLIENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientIds").getter(UpdateOpenIdConnectIdentityTokenConfiguration.getter(UpdateOpenIdConnectIdentityTokenConfiguration::clientIds)).setter(UpdateOpenIdConnectIdentityTokenConfiguration.setter(Builder::clientIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ID_CLAIM_FIELD, CLIENT_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String principalIdClaim;
    private final List<String> clientIds;

    private UpdateOpenIdConnectIdentityTokenConfiguration(BuilderImpl builder) {
        this.principalIdClaim = builder.principalIdClaim;
        this.clientIds = builder.clientIds;
    }

    public final String principalIdClaim() {
        return this.principalIdClaim;
    }

    public final boolean hasClientIds() {
        return this.clientIds != null && !(this.clientIds instanceof SdkAutoConstructList);
    }

    public final List<String> clientIds() {
        return this.clientIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principalIdClaim());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientIds() ? this.clientIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenIdConnectIdentityTokenConfiguration)) {
            return false;
        }
        UpdateOpenIdConnectIdentityTokenConfiguration other = (UpdateOpenIdConnectIdentityTokenConfiguration)obj;
        return Objects.equals(this.principalIdClaim(), other.principalIdClaim()) && this.hasClientIds() == other.hasClientIds() && Objects.equals(this.clientIds(), other.clientIds());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOpenIdConnectIdentityTokenConfiguration").add("PrincipalIdClaim", (Object)(this.principalIdClaim() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientIds", (Object)(this.clientIds() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principalIdClaim": {
                return Optional.ofNullable(clazz.cast(this.principalIdClaim()));
            }
            case "clientIds": {
                return Optional.ofNullable(clazz.cast(this.clientIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpenIdConnectIdentityTokenConfiguration, T> g) {
        return obj -> g.apply((UpdateOpenIdConnectIdentityTokenConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String principalIdClaim;
        private List<String> clientIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenIdConnectIdentityTokenConfiguration model) {
            this.principalIdClaim(model.principalIdClaim);
            this.clientIds(model.clientIds);
        }

        public final String getPrincipalIdClaim() {
            return this.principalIdClaim;
        }

        public final void setPrincipalIdClaim(String principalIdClaim) {
            this.principalIdClaim = principalIdClaim;
        }

        @Override
        public final Builder principalIdClaim(String principalIdClaim) {
            this.principalIdClaim = principalIdClaim;
            return this;
        }

        public final Collection<String> getClientIds() {
            if (this.clientIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientIds;
        }

        public final void setClientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
        }

        @Override
        public final Builder clientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIds(String ... clientIds) {
            this.clientIds(Arrays.asList(clientIds));
            return this;
        }

        public UpdateOpenIdConnectIdentityTokenConfiguration build() {
            return new UpdateOpenIdConnectIdentityTokenConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateOpenIdConnectIdentityTokenConfiguration> {
        public Builder principalIdClaim(String var1);

        public Builder clientIds(Collection<String> var1);

        public Builder clientIds(String ... var1);
    }
}

