/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;

@SdkInternalApi
public class S3EventNotificationMethodToV2
extends Recipe {
    private static final MethodMatcher GET_EVENT_TIME = S3TransformUtils.v1EnMethodMatcher("S3EventNotification.S3EventNotificationRecord getEventTime(..)");
    private static final MethodMatcher GET_EXPIRY_TIME = S3TransformUtils.v1EnMethodMatcher("S3EventNotification.RestoreEventDataEntity getLifecycleRestorationExpiryTime(..)");

    public String getDisplayName() {
        return "S3 Event Notification method to v2";
    }

    public String getDescription() {
        return "S3 Event Notification method to v2";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends JavaVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (GET_EVENT_TIME.matches((MethodCall)method) || GET_EXPIRY_TIME.matches((MethodCall)method)) {
                JavaTemplate template = JavaTemplate.builder((String)"new DateTime(#{any(java.time.Instant)}.toEpochMilli())").build();
                J m = super.visitMethodInvocation(method, (Object)ctx);
                m = template.apply(this.getCursor(), ((J.MethodInvocation)m).getCoordinates().replace(), new Object[]{m});
                return m;
            }
            return method;
        }
    }
}

