/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.NamingUtils;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;

@SdkInternalApi
public class TransferManagerMethodsToV2
extends Recipe {
    private static final MethodMatcher DOWNLOAD_BUCKET_KEY_FILE = S3TransformUtils.v2TmMethodMatcher("download(String, String, java.io.File)");
    private static final MethodMatcher DOWNLOAD_BUCKET_KEY_FILE_TIMEOUT = S3TransformUtils.v2TmMethodMatcher("download(String, String, java.io.File, long)");
    private static final MethodMatcher DOWNLOAD_REQUEST_FILE = S3TransformUtils.v2TmMethodMatcher(String.format("download(%sGetObjectRequest, java.io.File)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher DOWNLOAD_REQUEST_FILE_TIMEOUT = S3TransformUtils.v2TmMethodMatcher(String.format("download(%sGetObjectRequest, java.io.File, long)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher UPLOAD_BUCKET_KEY_FILE = S3TransformUtils.v2TmMethodMatcher("upload(String, String, java.io.File)");
    private static final MethodMatcher COPY_REQUEST = S3TransformUtils.v2TmMethodMatcher(String.format("copy(%sCopyObjectRequest)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher COPY_BUCKET_KEY = S3TransformUtils.v2TmMethodMatcher("copy(String, String, String, String");
    private static final MethodMatcher DOWNLOAD_DIR = S3TransformUtils.v2TmMethodMatcher("downloadDirectory(String, String, java.io.File)");
    private static final MethodMatcher UPLOAD_DIR = S3TransformUtils.v2TmMethodMatcher("uploadDirectory(String, String, java.io.File, boolean)");
    private static final MethodMatcher GET_BYTES_TRANSFERRED = S3TransformUtils.v2TransferProgressMethodMatcher("getBytesTransferred()");
    private static final MethodMatcher GET_TOTAL_BYTES_TO_TRANSFER = S3TransformUtils.v2TransferProgressMethodMatcher("getTotalBytesToTransfer()");
    private static final MethodMatcher GET_PERCENT_TRANSFERRED = S3TransformUtils.v2TransferProgressMethodMatcher("getPercentTransferred()");
    private static final Pattern S3_TM_CREDENTIAL = Pattern.compile("software.amazon.awssdk.transfer.s3.S3TransferManager");
    private static final Pattern V2_AWS_CREDENTIALS = Pattern.compile("software.amazon.awssdk.auth.credentials.AwsCredentials");
    private static final Pattern V2_CREDENTIAL_PROVIDER = Pattern.compile("software.amazon.awssdk.auth.credentials.AwsCredentialsProvider");

    public String getDisplayName() {
        return "Transfer Manager Methods to V2";
    }

    public String getDescription() {
        return "Transfer Manager Methods to V2";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (DOWNLOAD_BUCKET_KEY_FILE.matches(method, false)) {
                method = this.transformDownloadWithBucketKeyFile(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (DOWNLOAD_BUCKET_KEY_FILE_TIMEOUT.matches(method, false)) {
                method = this.transformDownloadWithBucketKeyFileTimeout(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (DOWNLOAD_REQUEST_FILE.matches(method, false)) {
                method = this.transformDownloadWithRequestFile(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (DOWNLOAD_REQUEST_FILE_TIMEOUT.matches(method, false)) {
                method = this.transformDownloadWithRequestFileTimeout(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (COPY_REQUEST.matches(method, false)) {
                method = this.transformCopyWithRequest(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (COPY_BUCKET_KEY.matches(method, false)) {
                method = this.transformCopyWithBucketKey(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (UPLOAD_BUCKET_KEY_FILE.matches(method, false)) {
                method = this.transformUploadWithBucketKeyFile(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (DOWNLOAD_DIR.matches(method, false)) {
                method = this.transformDownloadDirectory(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (UPLOAD_DIR.matches(method, false)) {
                method = this.transformUploadDirectory(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (GET_BYTES_TRANSFERRED.matches(method, false)) {
                String newMethodName = "snapshot().transferredBytes()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (GET_TOTAL_BYTES_TO_TRANSFER.matches(method, false)) {
                String newMethodName = "snapshot().totalBytes()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (GET_PERCENT_TRANSFERRED.matches(method, false)) {
                String newMethodName = "snapshot().ratioTransferred()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            JavaType type = newClass.getType();
            if (!(type instanceof JavaType.FullyQualified)) {
                return newClass;
            }
            if (type.isAssignableFrom(S3_TM_CREDENTIAL) && newClass.getArguments().size() == 1 && ((Expression)newClass.getArguments().get(0)).getType() != null) {
                Expression arg = (Expression)newClass.getArguments().get(0);
                if (arg.getType().isAssignableFrom(V2_AWS_CREDENTIALS)) {
                    this.addS3AsyncClientImport();
                    this.addStaticCredentialsProviderImport();
                    return JavaTemplate.builder((String)"S3TransferManager.builder().s3Client(S3AsyncClient.builder().credentialsProvider(StaticCredentialsProvider.create(#{any()})).build()).build()").build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{arg});
                }
                if (arg.getType().isAssignableFrom(V2_CREDENTIAL_PROVIDER)) {
                    this.addS3AsyncClientImport();
                    return JavaTemplate.builder((String)"S3TransferManager.builder().s3Client(S3AsyncClient.builder().credentialsProvider(#{any()}).build()).build()").build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{arg});
                }
            }
            return super.visitNewClass(newClass, (Object)executionContext);
        }

        private J.MethodInvocation transformDownloadDirectory(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadDirectory(DownloadDirectoryRequest.builder().bucket(#{any()}).listObjectsV2RequestTransformer(builder -> builder.prefix(#{any()})).destination(#{any()}.toPath()).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addTmImport("DownloadDirectoryRequest");
            return method;
        }

        private J.MethodInvocation transformUploadDirectory(J.MethodInvocation method) {
            String v2Method = "#{any()}.uploadDirectory(UploadDirectoryRequest.builder().bucket(#{any()}).s3Prefix(#{any()}).source(#{any()}.toPath()).maxDepth(#{any()} ? Integer.MAX_VALUE : 1).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2), method.getArguments().get(3)});
            this.addTmImport("UploadDirectoryRequest");
            return method;
        }

        private J.MethodInvocation transformUploadWithBucketKeyFile(J.MethodInvocation method) {
            String v2Method = "#{any()}.uploadFile(UploadFileRequest.builder().putObjectRequest(PutObjectRequest.builder().bucket(#{any()}).key(#{any()}).build()).source(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addTmImport("UploadFileRequest");
            this.addS3Import("PutObjectRequest");
            return method;
        }

        private J.MethodInvocation transformCopyWithRequest(J.MethodInvocation method) {
            String v2Method = "#{any()}.copy(CopyRequest.builder().copyObjectRequest(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0)});
            this.addTmImport("CopyRequest");
            return method;
        }

        private J.MethodInvocation transformCopyWithBucketKey(J.MethodInvocation method) {
            String v2Method = "#{any()}.copy(CopyRequest.builder().copyObjectRequest(CopyObjectRequest.builder().sourceBucket(#{any()}).sourceKey(#{any()}).destinationBucket(#{any()}).destinationKey(#{any()}).build()).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2), method.getArguments().get(3)});
            this.addTmImport("CopyRequest");
            this.addS3Import("CopyObjectRequest");
            return method;
        }

        private J.MethodInvocation transformDownloadWithRequestFile(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadFile(DownloadFileRequest.builder().getObjectRequest(#{any()}).destination(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1)});
            this.addTmImport("DownloadFileRequest");
            return method;
        }

        private J.MethodInvocation transformDownloadWithRequestFileTimeout(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadFile(DownloadFileRequest.builder().getObjectRequest(#{any()}.toBuilder().overrideConfiguration(#{any()}.overrideConfiguration().get().toBuilder().apiCallTimeout(Duration.ofMillis(#{any()})).build()).build()).destination(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(0), method.getArguments().get(2), method.getArguments().get(1)});
            this.addTmImport("DownloadFileRequest");
            return method;
        }

        private J.MethodInvocation transformDownloadWithBucketKeyFile(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadFile(DownloadFileRequest.builder().getObjectRequest(GetObjectRequest.builder().bucket(#{any()}).key(#{any()}).build()).destination(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addTmImport("DownloadFileRequest");
            this.addS3Import("GetObjectRequest");
            return method;
        }

        private J.MethodInvocation transformDownloadWithBucketKeyFileTimeout(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadFile(DownloadFileRequest.builder().getObjectRequest(GetObjectRequest.builder().bucket(#{any()}).key(#{any()}).overrideConfiguration(AwsRequestOverrideConfiguration.builder().apiCallTimeout(Duration.ofMillis(#{any()})).build()).build()).destination(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(3), method.getArguments().get(2)});
            this.addTmImport("DownloadFileRequest");
            this.addS3Import("GetObjectRequest");
            this.addRequestOverrideConfigImport();
            this.addDurationImport();
            return method;
        }

        private void addTmImport(String pojoName) {
            String fqcn = "software.amazon.awssdk.transfer.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addS3Import(String pojoName) {
            String fqcn = "software.amazon.awssdk.services.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addDurationImport() {
            this.doAfterVisit((TreeVisitor)new AddImport("java.time.Duration", null, false));
        }

        private void addRequestOverrideConfigImport() {
            this.doAfterVisit((TreeVisitor)new AddImport("software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration", null, false));
        }

        private void addS3AsyncClientImport() {
            this.doAfterVisit((TreeVisitor)new AddImport("software.amazon.awssdk.services.s3.S3AsyncClient", null, false));
        }

        private void addStaticCredentialsProviderImport() {
            this.doAfterVisit((TreeVisitor)new AddImport("software.amazon.awssdk.auth.credentials.StaticCredentialsProvider", null, false));
        }
    }
}

