/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.v2migration.internal.utils.NamingUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class V1SetterToV2
extends Recipe {
    private static final Map<String, String> CLIENT_CONFIG_NAMING_MAPPING = ImmutableMap.builder().put((Object)"credentials", (Object)"credentialsProvider").put((Object)"clientConfiguration", (Object)"overrideConfiguration").put((Object)"endpointConfiguration", (Object)"endpointOverride").build();

    public String getDisplayName() {
        return "V1 Setter to V2";
    }

    public String getDescription() {
        return "Transforms V1 setter to fluent setter in V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new V1SetterToV2Visitor();
    }

    private static class V1SetterToV2Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private V1SetterToV2Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation previousMethodInvocation, ExecutionContext executionContext) {
            J.MethodInvocation method = super.visitMethodInvocation(previousMethodInvocation, (Object)executionContext);
            JavaType selectType = null;
            Expression select = method.getSelect();
            if (select != null) {
                selectType = select.getType();
            }
            JavaType.Method methodType = method.getMethodType();
            if (selectType == null || methodType == null) {
                return method;
            }
            String methodName = method.getSimpleName();
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)selectType);
            if (fullyQualified == null || !V1SetterToV2Visitor.shouldChangeSetter(fullyQualified)) {
                return method;
            }
            if (!(NamingUtils.isWither(methodName) || NamingUtils.isSetter(methodName) || V1SetterToV2Visitor.isClientBuilderClass(methodType))) {
                return method;
            }
            if (NamingUtils.isWither(methodName)) {
                methodName = NamingUtils.removeWith(methodName);
            } else if (NamingUtils.isSetter(methodName)) {
                methodName = NamingUtils.removeSet(methodName);
            }
            if ("bucketName".equals(methodName)) {
                methodName = "bucket";
            }
            if (V1SetterToV2Visitor.isClientBuilderClass(methodType)) {
                methodName = CLIENT_CONFIG_NAMING_MAPPING.getOrDefault(methodName, methodName);
            }
            methodType = methodType.withName(methodName).withReturnType(selectType).withDeclaringType(fullyQualified);
            method = method.withName(method.getName().withSimpleName(methodName).withType((JavaType)methodType)).withMethodType(methodType);
            return (J.MethodInvocation)this.maybeAutoFormat((J)previousMethodInvocation, (J)method, executionContext);
        }

        private static boolean isClientBuilderClass(JavaType.Method methodType) {
            String fullyQualifiedName = methodType.getDeclaringType().getFullyQualifiedName();
            return AwsSyncClientBuilder.class.getCanonicalName().equals(fullyQualifiedName) || AwsAsyncClientBuilder.class.getCanonicalName().equals(fullyQualifiedName);
        }

        private static boolean shouldChangeSetter(JavaType.FullyQualified selectType) {
            return SdkTypeUtils.isEligibleToConvertToBuilder(selectType) || SdkTypeUtils.isV2ModelBuilder((JavaType)selectType) || SdkTypeUtils.isV2CoreClassBuilder(selectType.getFullyQualifiedName());
        }
    }
}

