/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;

@SdkInternalApi
public class S3AddImportsAndComments
extends Recipe {
    private static final MethodMatcher CREATE_BUCKET = S3TransformUtils.v1S3MethodMatcher("createBucket(String, com.amazonaws.services.s3.model.Region");
    private static final MethodMatcher LIST_NEXT_BATCH_OBJECTS = S3TransformUtils.v1S3MethodMatcher("listNextBatchOfObjects(..)");
    private static final MethodMatcher LIST_NEXT_BATCH_VERSIONS = S3TransformUtils.v1S3MethodMatcher("listNextBatchOfVersions(..)");
    private static final MethodMatcher GET_METADATA = S3TransformUtils.v1S3MethodMatcher("getCachedResponseMetadata(..)");
    private static final MethodMatcher SET_BUCKET_ACL = S3TransformUtils.v1S3MethodMatcher("setBucketAcl(..)");
    private static final MethodMatcher SET_BUCKET_LOGGING = S3TransformUtils.v1S3MethodMatcher("setBucketLoggingConfiguration(..)");
    private static final MethodMatcher SET_ENDPOINT = S3TransformUtils.v1S3MethodMatcher("setEndpoint(..)");
    private static final MethodMatcher SET_OBJECT_ACL = S3TransformUtils.v1S3MethodMatcher("setObjectAcl(..)");
    private static final MethodMatcher SET_REGION = S3TransformUtils.v1S3MethodMatcher("setRegion(..)");
    private static final MethodMatcher SET_PAYMENT_CONFIGURATION = S3TransformUtils.v1S3MethodMatcher("setRequestPaymentConfiguration(..)");
    private static final MethodMatcher SET_S3CLIENT_OPTIONS = S3TransformUtils.v1S3MethodMatcher("setS3ClientOptions(..)");
    private static final MethodMatcher SELECT_OBJECT_CONTENT = S3TransformUtils.v1S3MethodMatcher("selectObjectContent(..)");
    private static final MethodMatcher SET_LIFECYCLE_CONFIGURATION = S3TransformUtils.v1S3MethodMatcher("setBucketLifecycleConfiguration(..)");
    private static final MethodMatcher SET_TAGGING_CONFIGURATION = S3TransformUtils.v1S3MethodMatcher("setBucketTaggingConfiguration(..)");
    private static final Pattern CANNED_ACL = Pattern.compile("com.amazonaws.services.s3.model.CannedAccessControlList");
    private static final Pattern GET_OBJECT_REQUEST = Pattern.compile("com.amazonaws.services.s3.model.GetObjectRequest");
    private static final Pattern CREATE_BUCKET_REQUEST = Pattern.compile("com.amazonaws.services.s3.model.CreateBucketRequest");
    private static final Pattern DELETE_OBJECTS_RESULT = Pattern.compile("com.amazonaws.services.s3.model.DeleteObjectsResult");
    private static final Pattern INITIATE_MPU = Pattern.compile("com.amazonaws.services.s3.model.InitiateMultipartUpload");
    private static final Pattern MULTI_FACTOR_AUTH = Pattern.compile("com.amazonaws.services.s3.model.MultiFactorAuthentication");
    private static final Pattern SET_BUCKET_VERSION_REQUEST = Pattern.compile("com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest");
    private static final Pattern BUCKET_NOTIFICATION_CONFIG = Pattern.compile("com.amazonaws.services.s3.model.BucketNotificationConfiguration");

    public String getDisplayName() {
        return "Add imports and comments to unsupported S3 transforms.";
    }

    public String getDescription() {
        return "Add imports and comments to unsupported S3 transforms.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            boolean isSetObjectAcl = SET_OBJECT_ACL.matches((MethodCall)method);
            boolean isSetBucketAcl = SET_BUCKET_ACL.matches((MethodCall)method);
            if (isSetObjectAcl || isSetBucketAcl) {
                this.removeV1S3ModelImport("CannedAccessControlList");
                this.maybeAddV2CannedAclImport(method.getArguments(), isSetObjectAcl, isSetBucketAcl);
                String comment = "Transform for AccessControlList and CannedAccessControlList not supported. In v2, CannedAccessControlList is replaced by BucketCannedACL for buckets and ObjectCannedACL for objects." + this.devGuideLink("AccessControlList");
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (LIST_NEXT_BATCH_OBJECTS.matches((MethodCall)method)) {
                String comment = "Transform for listNextBatchOfObjects method not supported. listNextBatchOfObjects() only exists in SDK v1, for SDK v2 use either listObjectsV2Paginator().stream() for automatic pagination or manually handle pagination with listObjectsV2() and nextToken in the response for more control" + this.devGuideLink(method.getSimpleName());
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (LIST_NEXT_BATCH_VERSIONS.matches((MethodCall)method)) {
                String comment = "Transform for listNextBatchOfVersions method not supported.listNextBatchOfVersions() only exists in SDK v1, for SDK v2 use either listObjectVersionsPaginator().stream for automatic pagination or manually handle pagination with listObjectVersions() and VersionIdMarker/KeyMarker." + this.devGuideLink(method.getSimpleName());
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (SET_REGION.matches((MethodCall)method)) {
                String comment = "Transform for setRegion method not supported. Please manually migrate your code by configuring the region in the s3 client builder" + this.devGuideLink(method.getSimpleName());
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (SET_S3CLIENT_OPTIONS.matches((MethodCall)method)) {
                String comment = "Transform for setS3ClientOptions method not supported. Please manually migrate setS3ClientOptions by configuring the equivalent settings in S3Configuration.builder() when building your S3Client." + this.devGuideLink(method.getSimpleName());
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (SELECT_OBJECT_CONTENT.matches((MethodCall)method)) {
                String comment = "Note: selectObjectContent is only supported in AWS SDK v2 with S3AsyncClient. Please manually migrate to event-based response handling using SelectObjectContentEventStream" + this.devGuideLink(method.getSimpleName());
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (CREATE_BUCKET.matches((MethodCall)method)) {
                String comment = "Transform for createBucket(String bucketName, Region region) method not supported. Please manually migrate your code by using the following pattern: createBucket(builder -> builder.bucket(bucketName).createBucketConfiguration(cfg -> cfg.locationConstraint(region)))";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (SET_ENDPOINT.matches((MethodCall)method)) {
                String comment = "Transform for setEndpoint method not supported. setEndpoint() method is removed in SDK v2. Please manually migrate your code by using endpointOverride(URI.create(endpoint)) in S3ClientBuilder";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (GET_METADATA.matches((MethodCall)method)) {
                String comment = "Transform for getCachedResponseMetadata method not supported. getCachedResponseMetadata() is removed in SDK v2. Please manually migrate your code by accessing metadata directly from specific response objects instead of cached metadata";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (SET_BUCKET_LOGGING.matches((MethodCall)method)) {
                this.removeV1S3ModelImport("BucketLoggingConfiguration");
                this.addV2S3ModelImport("BucketLoggingStatus");
                this.addV2S3ModelImport("LoggingEnabled");
                String comment = "Transform for setBucketLoggingConfiguration method not supported. The method is renamed to putBucketLogging. Please manually migrate your code by replacing BucketLoggingConfiguration with BucketLoggingStatus and LoggingEnabled builders, and updating the method name and parameters" + this.devGuideLink(method.getSimpleName());
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (SET_PAYMENT_CONFIGURATION.matches((MethodCall)method)) {
                String comment = "Transform for setRequestPaymentConfiguration method not supported. Payer enum is a separate class in v2 (not nested). Please manually migrate your code by updating from RequestPaymentConfiguration.Payer to just Payer, and adjust imports and names.";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (SET_LIFECYCLE_CONFIGURATION.matches((MethodCall)method)) {
                String comment = "Transform for setBucketLifecycleConfiguration method not supported. Please manually migrate your code by using builder pattern, updating from BucketLifecycleConfiguration.Rule to LifecycleRule, StorageClass to TransitionStorageClass, and adjust imports and names." + this.devGuideLink(method.getSimpleName());
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (SET_TAGGING_CONFIGURATION.matches((MethodCall)method)) {
                String comment = "Transform for setBucketTaggingConfiguration method not supported. Please manually migrate your code by using builder pattern, replacing TagSet.setTag() with .tagSet(Arrays.asList(Tag.builder())), and use Tagging instead of BucketTaggingConfiguration, and adjust imports and names." + this.devGuideLink(method.getSimpleName());
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            return method;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            boolean setBucketVersionUsingMFA;
            JavaType type = newClass.getType();
            if (!(type instanceof JavaType.FullyQualified)) {
                return newClass;
            }
            boolean bl = setBucketVersionUsingMFA = type.isAssignableFrom(SET_BUCKET_VERSION_REQUEST) && newClass.getArguments().size() == 3;
            if (type.isAssignableFrom(MULTI_FACTOR_AUTH) || setBucketVersionUsingMFA) {
                this.removeV1S3ModelImport("MultiFactorAuthentication");
                String comment = "v2 does not have a MultiFactorAuthentication POJO. Please manually set the String value on the request POJO." + this.devGuideLink("MultifactorAuthentication");
                return (J.NewClass)newClass.withComments(S3TransformUtils.createComments(comment));
            }
            if (type.isAssignableFrom(GET_OBJECT_REQUEST) && newClass.getArguments().size() == 1) {
                this.removeV1S3ModelImport("S3ObjectId");
                String comment = "v2 does not have S3ObjectId class. Please manually migrate the code by setting the configs directly into the request builder pattern." + this.devGuideLink("getObject-using-V1s-S3ObjectId");
                return (J.NewClass)newClass.withComments(S3TransformUtils.createComments(comment));
            }
            if (type.isAssignableFrom(INITIATE_MPU) && newClass.getArguments().size() == 3) {
                String comment = "Transform for ObjectMetadata in initiateMultipartUpload() method is not supported. Please manually migrate your code by replacing ObjectMetadata with individual setter methods or metadata map in the request builder." + this.devGuideLink("initiateMultipartUpload");
                return (J.NewClass)newClass.withComments(S3TransformUtils.createComments(comment));
            }
            if (type.isAssignableFrom(CREATE_BUCKET_REQUEST) && newClass.getArguments().size() == 2) {
                String comment = "Transform for createBucketRequest with region is not supported. Please manually migrate your code by configuring the region as locationConstraint in createBucketConfiguration in the request builder";
                return (J.NewClass)newClass.withComments(S3TransformUtils.createComments(comment));
            }
            if (type.isAssignableFrom(DELETE_OBJECTS_RESULT)) {
                String comment = "Transform for DeleteObjectsResult class is not supported. DeletedObject class is a separate class in v2 (not nested). Please manually migrate your code by updating DeleteObjectsResult.DeletedObject to s3.model.DeletedObject";
                return (J.NewClass)newClass.withComments(S3TransformUtils.createComments(comment));
            }
            if (type.isAssignableFrom(BUCKET_NOTIFICATION_CONFIG)) {
                String comment = "Transform for BucketNotificationConfiguration class is not supported. BucketNotificationConfiguration is renamed to NotificationConfiguration. There is no common abstract class for lambdaFunction/topic/queue configurations. Use specific builders instead of addConfiguration() to add configurations. Change the vararg arguments or EnumSet in specific configurations constructor to List<String> in v2" + this.devGuideLink("BucketNotificationConfiguration");
                return (J.NewClass)newClass.withComments(S3TransformUtils.createComments(comment));
            }
            return newClass;
        }

        private void maybeAddV2CannedAclImport(List<Expression> args, boolean isSetObjectAcl, boolean isSetBucketAcl) {
            for (Expression expr : args) {
                JavaType type = expr.getType();
                if (type == null || !type.isAssignableFrom(CANNED_ACL)) continue;
                this.removeV1S3ModelImport("CannedAccessControlList");
                if (isSetBucketAcl) {
                    this.addV2S3ModelImport("BucketCannedACL");
                }
                if (!isSetObjectAcl) continue;
                this.addV2S3ModelImport("ObjectCannedACL");
            }
        }

        private void removeV1S3ModelImport(String className) {
            this.doAfterVisit((TreeVisitor)new RemoveImport("com.amazonaws.services.s3.model." + className, true));
        }

        private void addV2S3ModelImport(String className) {
            this.doAfterVisit((TreeVisitor)new AddImport("software.amazon.awssdk.services.s3.model." + className, null, false));
        }

        private String devGuideLink(String name) {
            String prefix = " Please reference https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/migration-s3-client.html#V1-";
            return prefix + name;
        }
    }
}

