/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.List;
import java.util.Locale;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;

@SdkInternalApi
public class S3NonStreamingRequestToV2Complex
extends Recipe {
    private static final MethodMatcher DISABLE_REQUESTER_PAYS = S3TransformUtils.v2S3MethodMatcher("disableRequesterPays(String)");
    private static final MethodMatcher ENABLE_REQUESTER_PAYS = S3TransformUtils.v2S3MethodMatcher("enableRequesterPays(String)");
    private static final MethodMatcher IS_REQUESTER_PAYS_ENABLED = S3TransformUtils.v2S3MethodMatcher("isRequesterPaysEnabled(String)");
    private static final MethodMatcher GET_OBJECT_AS_STRING = S3TransformUtils.v2S3MethodMatcher("getObjectAsString(String, String)");
    private static final MethodMatcher GET_URL = S3TransformUtils.v2S3MethodMatcher("getUrl(String, String)");
    private static final MethodMatcher LIST_BUCKETS = S3TransformUtils.v2S3MethodMatcher("listBuckets()");
    private static final MethodMatcher RESTORE_OBJECT = S3TransformUtils.v2S3MethodMatcher("restoreObject(String, String, int)");
    private static final MethodMatcher SET_OBJECT_REDIRECT_LOCATION = S3TransformUtils.v2S3MethodMatcher("setObjectRedirectLocation(String, String, String)");
    private static final MethodMatcher CHANGE_OBJECT_STORAGE_CLASS = S3TransformUtils.v2S3MethodMatcher(String.format("changeObjectStorageClass(String, String, %sStorageClass)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher CREATE_BUCKET = S3TransformUtils.v2S3MethodMatcher("createBucket(String, String)");

    public String getDisplayName() {
        return "V1 S3 non-streaming requests to V2";
    }

    public String getDescription() {
        return "Transform usage of V1 S3 non-streaming requests to V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (S3TransformUtils.isCompleteMpuRequestMultipartUploadSetter(method)) {
                return this.transformCompleteMpuRequestCompletedPartsArg(method);
            }
            if (S3TransformUtils.isGeneratePresignedUrl(method)) {
                return (J.MethodInvocation)this.maybeAutoFormat((J)method, (J)this.transformGeneratePresignedUrl(method), executionContext);
            }
            if (DISABLE_REQUESTER_PAYS.matches(method, false)) {
                return this.transformSetRequesterPays(method, false);
            }
            if (ENABLE_REQUESTER_PAYS.matches(method, false)) {
                return this.transformSetRequesterPays(method, true);
            }
            if (IS_REQUESTER_PAYS_ENABLED.matches(method, false)) {
                return this.transformIsRequesterPays(method);
            }
            if (GET_OBJECT_AS_STRING.matches(method, false)) {
                return this.transformGetObjectAsString(method);
            }
            if (GET_URL.matches(method, false)) {
                return this.transformGetUrl(method);
            }
            if (LIST_BUCKETS.matches(method, false)) {
                return this.transformListBuckets(method);
            }
            if (RESTORE_OBJECT.matches(method, false)) {
                return this.transformRestoreObject(method);
            }
            if (SET_OBJECT_REDIRECT_LOCATION.matches(method, false)) {
                return this.transformSetObjectRedirectLocation(method);
            }
            if (CHANGE_OBJECT_STORAGE_CLASS.matches(method, false)) {
                return this.transformChangeObjectStorageClass(method);
            }
            if (CREATE_BUCKET.matches(method, false)) {
                return this.transformCreateBucket(method);
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }

        private J.MethodInvocation transformGeneratePresignedUrl(J.MethodInvocation method) {
            List args = method.getArguments();
            if (args.size() == 1) {
                return (J.MethodInvocation)method.withComments(S3TransformUtils.requestPojoTransformNotSupportedComment());
            }
            String httpMethod = this.determineHttpMethod(args);
            if (S3TransformUtils.isUnsupportedHttpMethod(httpMethod)) {
                return (J.MethodInvocation)method.withComments(S3TransformUtils.httpMethodNotSupportedComment(httpMethod));
            }
            if (httpMethod == null) {
                return (J.MethodInvocation)method.withComments(S3TransformUtils.assignedVariableHttpMethodNotSupportedComment());
            }
            String v2Method = String.format("S3Presigner.builder().s3Client(#{any()}).build()%n.presign%sObject(p -> p.%sObjectRequest(r -> r.bucket(#{any()}).key(#{any()}))%n.signatureDuration(Duration.between(Instant.now(), #{any()}.toInstant())))%n.url()", httpMethod, httpMethod.toLowerCase(Locale.ROOT));
            this.removeV1HttpMethodImport();
            this.addInstantImport();
            this.addDurationImport();
            this.addS3PresignerImport();
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), args.get(0), args.get(1), args.get(2)}).withComments(S3TransformUtils.presignerSingleInstanceSuggestion());
        }

        private String determineHttpMethod(List<Expression> args) {
            String httpMethod;
            if (args.size() == 3) {
                return "Get";
            }
            Expression argVal = args.get(3);
            switch (httpMethod = argVal.printTrimmed(this.getCursor())) {
                case "HttpMethod.GET": {
                    return "Get";
                }
                case "HttpMethod.PUT": {
                    return "Put";
                }
                case "HttpMethod.DELETE": {
                    return "Delete";
                }
                case "HttpMethod.HEAD": {
                    return "Head";
                }
                case "HttpMethod.POST": {
                    return "Post";
                }
                case "HttpMethod.PATCH": {
                    return "Patch";
                }
            }
            return null;
        }

        private J.MethodInvocation transformCompleteMpuRequestCompletedPartsArg(J.MethodInvocation method) {
            this.addImport("CompletedMultipartUpload");
            String v2Method = "CompletedMultipartUpload.builder().parts(#{any()}).build()";
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0)});
        }

        private J.MethodInvocation transformCreateBucket(J.MethodInvocation method) {
            String v2Method = "#{any()}.createBucket(CreateBucketRequest.builder().bucket(#{any()}).createBucketConfiguration(CreateBucketConfiguration.builder().locationConstraint(#{any()}).build()).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1)});
            this.addImport("CreateBucketRequest");
            this.addImport("CreateBucketConfiguration");
            return method;
        }

        private J.MethodInvocation transformChangeObjectStorageClass(J.MethodInvocation method) {
            String v2Method = "#{any()}.copyObject(CopyObjectRequest.builder().sourceBucket(#{any()}).sourceKey(#{any()}).destinationBucket(#{any()}).destinationKey(#{any()}).storageClass(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addImport("CopyObjectRequest");
            return method;
        }

        private J.MethodInvocation transformSetObjectRedirectLocation(J.MethodInvocation method) {
            String v2Method = "#{any()}.copyObject(CopyObjectRequest.builder().sourceBucket(#{any()}).sourceKey(#{any()}).destinationBucket(#{any()}).destinationKey(#{any()}).websiteRedirectLocation(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addImport("CopyObjectRequest");
            return method;
        }

        private J.MethodInvocation transformRestoreObject(J.MethodInvocation method) {
            String v2Method = "#{any()}.restoreObject(RestoreObjectRequest.builder().bucket(#{any()}).key(#{any()}).restoreRequest(RestoreRequest.builder().days(#{any()}).build()).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addImport("RestoreObjectRequest");
            this.addImport("RestoreRequest");
            return method;
        }

        private J.MethodInvocation transformListBuckets(J.MethodInvocation method) {
            String v2Method = "#{any()}.listBuckets().buckets()";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect()});
            return method;
        }

        private J.MethodInvocation transformGetObjectAsString(J.MethodInvocation method) {
            String v2Method = "#{any()}.getObjectAsBytes(GetObjectRequest.builder().bucket(#{any()}).key(#{any()}).build()).asUtf8String()";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1)});
            this.addImport("GetObjectRequest");
            return method;
        }

        private J.MethodInvocation transformGetUrl(J.MethodInvocation method) {
            String v2Method = "#{any()}.utilities().getUrl(GetUrlRequest.builder().bucket(#{any()}).key(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1)});
            this.addImport("GetUrlRequest");
            return method;
        }

        private J.MethodInvocation transformIsRequesterPays(J.MethodInvocation method) {
            String v2Method = "#{any()}.getBucketRequestPayment(GetBucketRequestPaymentRequest.builder().bucket(#{any()}).build()).payer().toString().equals(\"Requester\")";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0)});
            this.addImport("GetBucketRequestPaymentRequest");
            return method;
        }

        private J.MethodInvocation transformSetRequesterPays(J.MethodInvocation method, boolean enable) {
            String payer = enable ? "REQUESTER" : "BUCKET_OWNER";
            String v2Method = String.format("#{any()}.putBucketRequestPayment(PutBucketRequestPaymentRequest.builder().bucket(#{any()}).requestPaymentConfiguration(RequestPaymentConfiguration.builder().payer(Payer.%s).build()).build())", payer);
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0)});
            this.addImport("PutBucketRequestPaymentRequest");
            this.addImport("RequestPaymentConfiguration");
            this.addImport("Payer");
            return method;
        }

        private void removeV1HttpMethodImport() {
            this.doAfterVisit((TreeVisitor)new RemoveImport("com.amazonaws.HttpMethod", true));
        }

        private void addInstantImport() {
            String fqcn = "java.time.Instant";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addDurationImport() {
            String fqcn = "java.time.Duration";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addS3PresignerImport() {
            String fqcn = "software.amazon.awssdk.services.s3.presigner.S3Presigner";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addImport(String pojoName) {
            String fqcn = "software.amazon.awssdk.services.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }
    }
}

