/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class DateToInstant
extends Recipe {
    private static final Pattern DATE_PATTERN = Pattern.compile(Date.class.getCanonicalName());

    @NlsRewrite.DisplayName
    public String getDisplayName() {
        return "Convert Date to Instant";
    }

    @NlsRewrite.Description
    public String getDescription() {
        return "Convert Date to Instant by calling Date#toInstant";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new DateToInstantVisitor();
    }

    private static final class DateToInstantVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private DateToInstantVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation originalMethod, ExecutionContext ctx) {
            J.MethodInvocation method = super.visitMethodInvocation(originalMethod, (Object)ctx);
            if (!DateToInstantVisitor.isV2ModelSetterWithDateParam(method)) {
                return method;
            }
            JavaTemplate template = JavaTemplate.builder((String)"#{any()}.toInstant()").contextSensitive().build();
            return (J.MethodInvocation)template.apply(this.updateCursor((Tree)method), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0)});
        }

        private static boolean isV2ModelSetterWithDateParam(J.MethodInvocation method) {
            JavaType.Method mt = method.getMethodType();
            if (mt == null) {
                return false;
            }
            JavaType.FullyQualified declaringType = mt.getDeclaringType();
            List parameterTypes = mt.getParameterTypes();
            if (parameterTypes.size() != 1) {
                return false;
            }
            JavaType javaType = (JavaType)parameterTypes.get(0);
            if (javaType == null) {
                return false;
            }
            boolean isDateParam = javaType.isAssignableFrom(DATE_PATTERN);
            return SdkTypeUtils.isV2ModelBuilder((JavaType)declaringType) && isDateParam;
        }
    }
}

