/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.cache;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.cache.CachedSupplier;

@SdkProtectedApi
public class NonBlocking
implements CachedSupplier.PrefetchStrategy {
    private static final Logger log = Logger.loggerFor(NonBlocking.class);
    private final AtomicBoolean currentlyRefreshing = new AtomicBoolean(false);
    private final ScheduledExecutorService executor;

    public NonBlocking(String asyncThreadName) {
        this.executor = NonBlocking.newExecutor(asyncThreadName);
    }

    private static ScheduledExecutorService newExecutor(String asyncThreadName) {
        Validate.paramNotBlank(asyncThreadName, "asyncThreadName");
        return new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().daemonThreads(true).threadNamePrefix(asyncThreadName).build());
    }

    @Override
    public void initializeCachedSupplier(CachedSupplier<?> cachedSupplier) {
        this.executor.execute(cachedSupplier::get);
        this.scheduleRefresh(cachedSupplier::get);
    }

    private void scheduleRefresh(Runnable valueUpdater) {
        this.executor.schedule(() -> {
            try {
                valueUpdater.run();
            }
            finally {
                this.scheduleRefresh(valueUpdater);
            }
        }, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void prefetch(Runnable valueUpdater) {
        if (this.currentlyRefreshing.compareAndSet(false, true)) {
            try {
                this.executor.submit(() -> {
                    try {
                        valueUpdater.run();
                    }
                    catch (RuntimeException e) {
                        log.warn(() -> "Exception occurred in AWS SDK background task.", e);
                    }
                    finally {
                        this.currentlyRefreshing.set(false);
                    }
                });
            }
            catch (RuntimeException e) {
                this.currentlyRefreshing.set(false);
                throw e;
            }
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

