/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.ThreadSafe;

@ThreadSafe
@SdkProtectedApi
public final class DateUtils {
    static final DateTimeFormatter ALTERNATE_ISO_8601_DATE_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").toFormatter().withZone(ZoneOffset.UTC);

    private DateUtils() {
    }

    public static Instant parseIso8601Date(String dateString) {
        if (dateString.endsWith("+0000")) {
            dateString = dateString.substring(0, dateString.length() - 5).concat("Z");
        }
        try {
            return DateUtils.parseInstant(dateString, DateTimeFormatter.ISO_INSTANT);
        }
        catch (DateTimeParseException e) {
            return DateUtils.parseInstant(dateString, ALTERNATE_ISO_8601_DATE_FORMAT);
        }
    }

    public static String formatIso8601Date(Instant date) {
        return DateTimeFormatter.ISO_INSTANT.format(date);
    }

    public static Instant parseRfc1123Date(String dateString) {
        if (dateString == null) {
            return null;
        }
        return DateUtils.parseInstant(dateString, DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    public static String formatRfc1123Date(Instant instant) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(instant, ZoneOffset.UTC));
    }

    public static long numberOfDaysSinceEpoch(long milliSinceEpoch) {
        return Duration.ofMillis(milliSinceEpoch).toDays();
    }

    private static Instant parseInstant(String dateString, DateTimeFormatter formatter) {
        return formatter.withZone(ZoneOffset.UTC).parse((CharSequence)dateString, Instant::from);
    }
}

