/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.utils.DaemonThreadFactory;
import software.amazon.awssdk.utils.NamedThreadFactory;

@SdkProtectedApi
public class ThreadFactoryBuilder {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private String threadNamePrefix = "aws-java-sdk-thread";
    private Boolean daemonThreads = true;

    public ThreadFactoryBuilder threadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        return this;
    }

    public ThreadFactoryBuilder daemonThreads(Boolean daemonThreads) {
        this.daemonThreads = daemonThreads;
        return this;
    }

    public ThreadFactory build() {
        String threadNamePrefixWithPoolNumber = this.threadNamePrefix + "-" + POOL_NUMBER.getAndIncrement();
        ThreadFactory result = new NamedThreadFactory(Executors.defaultThreadFactory(), threadNamePrefixWithPoolNumber);
        if (this.daemonThreads.booleanValue()) {
            result = new DaemonThreadFactory(result);
        }
        return result;
    }
}

