/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.urlconnection;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.AbortableCallable;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.NumericUtils;

@SdkPublicApi
public final class UrlConnectionHttpClient
implements SdkHttpClient {
    private final AttributeMap options;

    private UrlConnectionHttpClient(AttributeMap options) {
        this.options = options;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public AbortableCallable<SdkHttpFullResponse> prepareRequest(SdkHttpFullRequest request, SdkRequestContext requestContext) {
        HttpURLConnection connection = this.createAndConfigureConnection(request);
        return new RequestCallable(connection, request);
    }

    public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
        return Optional.ofNullable(this.options.get(key));
    }

    public void close() {
    }

    private HttpURLConnection createAndConfigureConnection(SdkHttpFullRequest request) {
        HttpURLConnection connection = (HttpURLConnection)FunctionalUtils.invokeSafely(() -> (HttpURLConnection)request.getUri().toURL().openConnection());
        request.headers().forEach((key, values) -> values.forEach(value -> connection.setRequestProperty((String)key, (String)value)));
        FunctionalUtils.invokeSafely(() -> connection.setRequestMethod(request.method().name()));
        if (request.content().isPresent()) {
            connection.setDoOutput(true);
        }
        connection.setConnectTimeout(NumericUtils.saturatedCast((long)((Duration)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).toMillis()));
        connection.setReadTimeout(NumericUtils.saturatedCast((long)((Duration)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).toMillis()));
        return connection;
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();

        private DefaultBuilder() {
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        public SdkHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new UrlConnectionHttpClient(this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }
    }

    public static interface Builder
    extends SdkHttpClient.Builder<Builder> {
        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);
    }

    private static class RequestCallable
    implements AbortableCallable<SdkHttpFullResponse> {
        private final HttpURLConnection connection;
        private final SdkHttpFullRequest request;

        private RequestCallable(HttpURLConnection connection, SdkHttpFullRequest request) {
            this.connection = connection;
            this.request = request;
        }

        public SdkHttpFullResponse call() throws Exception {
            this.connection.connect();
            this.request.content().ifPresent(content -> {
                Long cfr_ignored_0 = (Long)FunctionalUtils.invokeSafely(() -> IoUtils.copy((InputStream)content, (OutputStream)this.connection.getOutputStream()));
            });
            int responseCode = this.connection.getResponseCode();
            boolean isErrorResponse = HttpStatusFamily.of((int)responseCode).isOneOf(new HttpStatusFamily[]{HttpStatusFamily.CLIENT_ERROR, HttpStatusFamily.SERVER_ERROR});
            InputStream content2 = !isErrorResponse ? this.connection.getInputStream() : this.connection.getErrorStream();
            return (SdkHttpFullResponse)SdkHttpFullResponse.builder().statusCode(responseCode).statusText(this.connection.getResponseMessage()).content(new AbortableInputStream(content2, () -> {})).headers(this.extractHeaders(this.connection)).build();
        }

        private Map<String, List<String>> extractHeaders(HttpURLConnection response) {
            return response.getHeaderFields().entrySet().stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void abort() {
            this.connection.disconnect();
        }
    }
}

