/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExclusionStatus {
    EXCLUDED("excluded"),
    INCLUDED("included"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExclusionStatus> VALUE_MAP;
    private final String value;

    private ExclusionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExclusionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExclusionStatus> knownValues() {
        EnumSet<ExclusionStatus> knownValues = EnumSet.allOf(ExclusionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExclusionStatus.class, ExclusionStatus::toString);
    }
}

