/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.translate.TranslateAsyncClient;
import software.amazon.awssdk.services.translate.TranslateServiceClientConfiguration;
import software.amazon.awssdk.services.translate.internal.TranslateServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.translate.model.ConcurrentModificationException;
import software.amazon.awssdk.services.translate.model.ConflictException;
import software.amazon.awssdk.services.translate.model.CreateParallelDataRequest;
import software.amazon.awssdk.services.translate.model.CreateParallelDataResponse;
import software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest;
import software.amazon.awssdk.services.translate.model.DeleteParallelDataResponse;
import software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest;
import software.amazon.awssdk.services.translate.model.DeleteTerminologyResponse;
import software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.DetectedLanguageLowConfidenceException;
import software.amazon.awssdk.services.translate.model.GetParallelDataRequest;
import software.amazon.awssdk.services.translate.model.GetParallelDataResponse;
import software.amazon.awssdk.services.translate.model.GetTerminologyRequest;
import software.amazon.awssdk.services.translate.model.GetTerminologyResponse;
import software.amazon.awssdk.services.translate.model.ImportTerminologyRequest;
import software.amazon.awssdk.services.translate.model.ImportTerminologyResponse;
import software.amazon.awssdk.services.translate.model.InternalServerException;
import software.amazon.awssdk.services.translate.model.InvalidFilterException;
import software.amazon.awssdk.services.translate.model.InvalidParameterValueException;
import software.amazon.awssdk.services.translate.model.InvalidRequestException;
import software.amazon.awssdk.services.translate.model.LimitExceededException;
import software.amazon.awssdk.services.translate.model.ListLanguagesRequest;
import software.amazon.awssdk.services.translate.model.ListLanguagesResponse;
import software.amazon.awssdk.services.translate.model.ListParallelDataRequest;
import software.amazon.awssdk.services.translate.model.ListParallelDataResponse;
import software.amazon.awssdk.services.translate.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.translate.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.translate.model.ListTerminologiesRequest;
import software.amazon.awssdk.services.translate.model.ListTerminologiesResponse;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse;
import software.amazon.awssdk.services.translate.model.ResourceNotFoundException;
import software.amazon.awssdk.services.translate.model.ServiceUnavailableException;
import software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.StopTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.TagResourceRequest;
import software.amazon.awssdk.services.translate.model.TagResourceResponse;
import software.amazon.awssdk.services.translate.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.translate.model.TooManyRequestsException;
import software.amazon.awssdk.services.translate.model.TooManyTagsException;
import software.amazon.awssdk.services.translate.model.TranslateDocumentRequest;
import software.amazon.awssdk.services.translate.model.TranslateDocumentResponse;
import software.amazon.awssdk.services.translate.model.TranslateException;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.services.translate.model.TranslateTextResponse;
import software.amazon.awssdk.services.translate.model.UnsupportedDisplayLanguageCodeException;
import software.amazon.awssdk.services.translate.model.UnsupportedLanguagePairException;
import software.amazon.awssdk.services.translate.model.UntagResourceRequest;
import software.amazon.awssdk.services.translate.model.UntagResourceResponse;
import software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest;
import software.amazon.awssdk.services.translate.model.UpdateParallelDataResponse;
import software.amazon.awssdk.services.translate.transform.CreateParallelDataRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.DeleteParallelDataRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.DeleteTerminologyRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.DescribeTextTranslationJobRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.GetParallelDataRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.GetTerminologyRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.ImportTerminologyRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.ListLanguagesRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.ListParallelDataRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.ListTerminologiesRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.ListTextTranslationJobsRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.StartTextTranslationJobRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.StopTextTranslationJobRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.TranslateDocumentRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.TranslateTextRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.translate.transform.UpdateParallelDataRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultTranslateAsyncClient
implements TranslateAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultTranslateAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTranslateAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Translate#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateParallelDataResponse> createParallelData(CreateParallelDataRequest createParallelDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createParallelDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, createParallelDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateParallelData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateParallelDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateParallelData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateParallelDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createParallelDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$createParallelData$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$createParallelData$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteParallelDataResponse> deleteParallelData(DeleteParallelDataRequest deleteParallelDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteParallelDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, deleteParallelDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteParallelData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteParallelDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteParallelData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteParallelDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteParallelDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$deleteParallelData$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$deleteParallelData$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTerminologyResponse> deleteTerminology(DeleteTerminologyRequest deleteTerminologyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTerminologyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTerminologyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTerminology");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTerminologyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTerminology").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTerminologyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTerminologyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$deleteTerminology$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$deleteTerminology$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTextTranslationJobResponse> describeTextTranslationJob(DescribeTextTranslationJobRequest describeTextTranslationJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTextTranslationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, describeTextTranslationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTextTranslationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTextTranslationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTextTranslationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTextTranslationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTextTranslationJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$describeTextTranslationJob$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$describeTextTranslationJob$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetParallelDataResponse> getParallelData(GetParallelDataRequest getParallelDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getParallelDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, getParallelDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetParallelData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetParallelDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetParallelData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetParallelDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getParallelDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$getParallelData$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$getParallelData$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTerminologyResponse> getTerminology(GetTerminologyRequest getTerminologyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTerminologyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, getTerminologyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTerminology");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTerminologyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTerminology").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTerminologyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTerminologyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$getTerminology$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$getTerminology$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportTerminologyResponse> importTerminology(ImportTerminologyRequest importTerminologyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importTerminologyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, importTerminologyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportTerminology");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportTerminologyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportTerminology").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportTerminologyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importTerminologyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$importTerminology$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$importTerminology$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLanguagesResponse> listLanguages(ListLanguagesRequest listLanguagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLanguagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, listLanguagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLanguages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLanguagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLanguages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLanguagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLanguagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$listLanguages$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$listLanguages$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListParallelDataResponse> listParallelData(ListParallelDataRequest listParallelDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listParallelDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, listParallelDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListParallelData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListParallelDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParallelData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListParallelDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listParallelDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$listParallelData$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$listParallelData$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$listTagsForResource$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$listTagsForResource$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTerminologiesResponse> listTerminologies(ListTerminologiesRequest listTerminologiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTerminologiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, listTerminologiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTerminologies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTerminologiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTerminologies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTerminologiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTerminologiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$listTerminologies$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$listTerminologies$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTextTranslationJobsResponse> listTextTranslationJobs(ListTextTranslationJobsRequest listTextTranslationJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTextTranslationJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, listTextTranslationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTextTranslationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTextTranslationJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTextTranslationJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTextTranslationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTextTranslationJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$listTextTranslationJobs$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$listTextTranslationJobs$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartTextTranslationJobResponse> startTextTranslationJob(StartTextTranslationJobRequest startTextTranslationJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTextTranslationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, startTextTranslationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTextTranslationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTextTranslationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTextTranslationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartTextTranslationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startTextTranslationJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$startTextTranslationJob$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$startTextTranslationJob$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopTextTranslationJobResponse> stopTextTranslationJob(StopTextTranslationJobRequest stopTextTranslationJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTextTranslationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, stopTextTranslationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTextTranslationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTextTranslationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTextTranslationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopTextTranslationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopTextTranslationJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$stopTextTranslationJob$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$stopTextTranslationJob$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$tagResource$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$tagResource$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TranslateDocumentResponse> translateDocument(TranslateDocumentRequest translateDocumentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)translateDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, translateDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TranslateDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TranslateDocumentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TranslateDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TranslateDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)translateDocumentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$translateDocument$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$translateDocument$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TranslateTextResponse> translateText(TranslateTextRequest translateTextRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)translateTextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, translateTextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TranslateText");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TranslateTextResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TranslateText").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TranslateTextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)translateTextRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$translateText$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$translateText$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$untagResource$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$untagResource$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateParallelDataResponse> updateParallelData(UpdateParallelDataRequest updateParallelDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateParallelDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTranslateAsyncClient.resolveMetricPublishers(clientConfiguration, updateParallelDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Translate");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateParallelData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateParallelDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "DetectedLanguageLowConfidenceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DetectedLanguageLowConfidenceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DetectedLanguageLowConfidenceException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedLanguagePairException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguagePairException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguagePairException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "UnsupportedDisplayLanguageCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDisplayLanguageCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDisplayLanguageCodeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateParallelData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateParallelDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateParallelDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTranslateAsyncClient.lambda$updateParallelData$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTranslateAsyncClient.lambda$updateParallelData$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final TranslateServiceClientConfiguration serviceClientConfiguration() {
        return new TranslateServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "translate";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TranslateException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        TranslateServiceClientConfigurationBuilder serviceConfigBuilder = new TranslateServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateParallelData$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateParallelData$74(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateParallelDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$70(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$translateText$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$translateText$66(List metricPublishers, MetricCollector apiCallMetricCollector, TranslateTextResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$translateDocument$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$translateDocument$62(List metricPublishers, MetricCollector apiCallMetricCollector, TranslateDocumentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$58(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopTextTranslationJob$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTextTranslationJob$54(List metricPublishers, MetricCollector apiCallMetricCollector, StopTextTranslationJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startTextTranslationJob$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTextTranslationJob$50(List metricPublishers, MetricCollector apiCallMetricCollector, StartTextTranslationJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTextTranslationJobs$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTextTranslationJobs$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListTextTranslationJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTerminologies$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTerminologies$42(List metricPublishers, MetricCollector apiCallMetricCollector, ListTerminologiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$38(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listParallelData$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listParallelData$34(List metricPublishers, MetricCollector apiCallMetricCollector, ListParallelDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLanguages$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLanguages$30(List metricPublishers, MetricCollector apiCallMetricCollector, ListLanguagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importTerminology$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importTerminology$26(List metricPublishers, MetricCollector apiCallMetricCollector, ImportTerminologyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTerminology$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTerminology$22(List metricPublishers, MetricCollector apiCallMetricCollector, GetTerminologyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getParallelData$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getParallelData$18(List metricPublishers, MetricCollector apiCallMetricCollector, GetParallelDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTextTranslationJob$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTextTranslationJob$14(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTextTranslationJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTerminology$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTerminology$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTerminologyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteParallelData$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteParallelData$6(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteParallelDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createParallelData$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createParallelData$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateParallelDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

