/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.DisplayLanguageCode;
import software.amazon.awssdk.services.translate.model.Language;
import software.amazon.awssdk.services.translate.model.LanguagesListCopier;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLanguagesResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, ListLanguagesResponse> {
    private static final SdkField<List<Language>> LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Languages").getter(ListLanguagesResponse.getter(ListLanguagesResponse::languages)).setter(ListLanguagesResponse.setter(Builder::languages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Language::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISPLAY_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayLanguageCode").getter(ListLanguagesResponse.getter(ListLanguagesResponse::displayLanguageCodeAsString)).setter(ListLanguagesResponse.setter(Builder::displayLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayLanguageCode").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLanguagesResponse.getter(ListLanguagesResponse::nextToken)).setter(ListLanguagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGES_FIELD, DISPLAY_LANGUAGE_CODE_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLanguagesResponse.memberNameToFieldInitializer();
    private final List<Language> languages;
    private final String displayLanguageCode;
    private final String nextToken;

    private ListLanguagesResponse(BuilderImpl builder) {
        super(builder);
        this.languages = builder.languages;
        this.displayLanguageCode = builder.displayLanguageCode;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLanguages() {
        return this.languages != null && !(this.languages instanceof SdkAutoConstructList);
    }

    public final List<Language> languages() {
        return this.languages;
    }

    public final DisplayLanguageCode displayLanguageCode() {
        return DisplayLanguageCode.fromValue(this.displayLanguageCode);
    }

    public final String displayLanguageCodeAsString() {
        return this.displayLanguageCode;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLanguages() ? this.languages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.displayLanguageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLanguagesResponse)) {
            return false;
        }
        ListLanguagesResponse other = (ListLanguagesResponse)((Object)obj);
        return this.hasLanguages() == other.hasLanguages() && Objects.equals(this.languages(), other.languages()) && Objects.equals(this.displayLanguageCodeAsString(), other.displayLanguageCodeAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLanguagesResponse").add("Languages", this.hasLanguages() ? this.languages() : null).add("DisplayLanguageCode", (Object)this.displayLanguageCodeAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Languages": {
                return Optional.ofNullable(clazz.cast(this.languages()));
            }
            case "DisplayLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.displayLanguageCodeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Languages", LANGUAGES_FIELD);
        map.put("DisplayLanguageCode", DISPLAY_LANGUAGE_CODE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLanguagesResponse, T> g) {
        return obj -> g.apply((ListLanguagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private List<Language> languages = DefaultSdkAutoConstructList.getInstance();
        private String displayLanguageCode;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLanguagesResponse model) {
            super(model);
            this.languages(model.languages);
            this.displayLanguageCode(model.displayLanguageCode);
            this.nextToken(model.nextToken);
        }

        public final List<Language.Builder> getLanguages() {
            List<Language.Builder> result = LanguagesListCopier.copyToBuilder(this.languages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLanguages(Collection<Language.BuilderImpl> languages) {
            this.languages = LanguagesListCopier.copyFromBuilder(languages);
        }

        @Override
        public final Builder languages(Collection<Language> languages) {
            this.languages = LanguagesListCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Language ... languages) {
            this.languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<Language.Builder> ... languages) {
            this.languages(Stream.of(languages).map(c -> (Language)((Language.Builder)Language.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayLanguageCode() {
            return this.displayLanguageCode;
        }

        public final void setDisplayLanguageCode(String displayLanguageCode) {
            this.displayLanguageCode = displayLanguageCode;
        }

        @Override
        public final Builder displayLanguageCode(String displayLanguageCode) {
            this.displayLanguageCode = displayLanguageCode;
            return this;
        }

        @Override
        public final Builder displayLanguageCode(DisplayLanguageCode displayLanguageCode) {
            this.displayLanguageCode(displayLanguageCode == null ? null : displayLanguageCode.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLanguagesResponse build() {
            return new ListLanguagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLanguagesResponse> {
        public Builder languages(Collection<Language> var1);

        public Builder languages(Language ... var1);

        public Builder languages(Consumer<Language.Builder> ... var1);

        public Builder displayLanguageCode(String var1);

        public Builder displayLanguageCode(DisplayLanguageCode var1);

        public Builder nextToken(String var1);
    }
}

