/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DisplayLanguageCode {
    DE("de"),
    EN("en"),
    ES("es"),
    FR("fr"),
    IT("it"),
    JA("ja"),
    KO("ko"),
    PT("pt"),
    ZH("zh"),
    ZH_TW("zh-TW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DisplayLanguageCode> VALUE_MAP;
    private final String value;

    private DisplayLanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DisplayLanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DisplayLanguageCode> knownValues() {
        EnumSet<DisplayLanguageCode> knownValues = EnumSet.allOf(DisplayLanguageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DisplayLanguageCode.class, DisplayLanguageCode::toString);
    }
}

