/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.translate.TranslateAsyncClient;
import software.amazon.awssdk.services.translate.model.ListParallelDataRequest;
import software.amazon.awssdk.services.translate.model.ListParallelDataResponse;

public class ListParallelDataPublisher
implements SdkPublisher<ListParallelDataResponse> {
    private final TranslateAsyncClient client;
    private final ListParallelDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListParallelDataPublisher(TranslateAsyncClient client, ListParallelDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListParallelDataPublisher(TranslateAsyncClient client, ListParallelDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListParallelDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListParallelDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListParallelDataResponseFetcher
    implements AsyncPageFetcher<ListParallelDataResponse> {
        private ListParallelDataResponseFetcher() {
        }

        public boolean hasNextPage(ListParallelDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListParallelDataResponse> nextPage(ListParallelDataResponse previousPage) {
            if (previousPage == null) {
                return ListParallelDataPublisher.this.client.listParallelData(ListParallelDataPublisher.this.firstRequest);
            }
            return ListParallelDataPublisher.this.client.listParallelData((ListParallelDataRequest)((Object)ListParallelDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

