/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.ParallelDataConfig;
import software.amazon.awssdk.services.translate.model.TranslateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateParallelDataRequest
extends TranslateRequest
implements ToCopyableBuilder<Builder, UpdateParallelDataRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateParallelDataRequest.getter(UpdateParallelDataRequest::name)).setter(UpdateParallelDataRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateParallelDataRequest.getter(UpdateParallelDataRequest::description)).setter(UpdateParallelDataRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ParallelDataConfig> PARALLEL_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParallelDataConfig").getter(UpdateParallelDataRequest.getter(UpdateParallelDataRequest::parallelDataConfig)).setter(UpdateParallelDataRequest.setter(Builder::parallelDataConfig)).constructor(ParallelDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataConfig").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdateParallelDataRequest.getter(UpdateParallelDataRequest::clientToken)).setter(UpdateParallelDataRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, PARALLEL_DATA_CONFIG_FIELD, CLIENT_TOKEN_FIELD));
    private final String name;
    private final String description;
    private final ParallelDataConfig parallelDataConfig;
    private final String clientToken;

    private UpdateParallelDataRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.parallelDataConfig = builder.parallelDataConfig;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ParallelDataConfig parallelDataConfig() {
        return this.parallelDataConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParallelDataRequest)) {
            return false;
        }
        UpdateParallelDataRequest other = (UpdateParallelDataRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parallelDataConfig(), other.parallelDataConfig()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateParallelDataRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ParallelDataConfig", (Object)this.parallelDataConfig()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ParallelDataConfig": {
                return Optional.ofNullable(clazz.cast(this.parallelDataConfig()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateParallelDataRequest, T> g) {
        return obj -> g.apply((UpdateParallelDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private ParallelDataConfig parallelDataConfig;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParallelDataRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.parallelDataConfig(model.parallelDataConfig);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ParallelDataConfig.Builder getParallelDataConfig() {
            return this.parallelDataConfig != null ? this.parallelDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder parallelDataConfig(ParallelDataConfig parallelDataConfig) {
            this.parallelDataConfig = parallelDataConfig;
            return this;
        }

        public final void setParallelDataConfig(ParallelDataConfig.BuilderImpl parallelDataConfig) {
            this.parallelDataConfig = parallelDataConfig != null ? parallelDataConfig.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateParallelDataRequest build() {
            return new UpdateParallelDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateParallelDataRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder parallelDataConfig(ParallelDataConfig var1);

        default public Builder parallelDataConfig(Consumer<ParallelDataConfig.Builder> parallelDataConfig) {
            return this.parallelDataConfig((ParallelDataConfig)((ParallelDataConfig.Builder)ParallelDataConfig.builder().applyMutation(parallelDataConfig)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

