/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.EncryptionKey;
import software.amazon.awssdk.services.translate.model.LanguageCodeStringListCopier;
import software.amazon.awssdk.services.translate.model.ParallelDataConfig;
import software.amazon.awssdk.services.translate.model.ParallelDataStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParallelDataProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParallelDataProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ParallelDataProperties.getter(ParallelDataProperties::name)).setter(ParallelDataProperties.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ParallelDataProperties.getter(ParallelDataProperties::arn)).setter(ParallelDataProperties.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ParallelDataProperties.getter(ParallelDataProperties::description)).setter(ParallelDataProperties.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ParallelDataProperties.getter(ParallelDataProperties::statusAsString)).setter(ParallelDataProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLanguageCode").getter(ParallelDataProperties.getter(ParallelDataProperties::sourceLanguageCode)).setter(ParallelDataProperties.setter(Builder::sourceLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build()}).build();
    private static final SdkField<List<String>> TARGET_LANGUAGE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLanguageCodes").getter(ParallelDataProperties.getter(ParallelDataProperties::targetLanguageCodes)).setter(ParallelDataProperties.setter(Builder::targetLanguageCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ParallelDataConfig> PARALLEL_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParallelDataConfig").getter(ParallelDataProperties.getter(ParallelDataProperties::parallelDataConfig)).setter(ParallelDataProperties.setter(Builder::parallelDataConfig)).constructor(ParallelDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataConfig").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ParallelDataProperties.getter(ParallelDataProperties::message)).setter(ParallelDataProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Long> IMPORTED_DATA_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ImportedDataSize").getter(ParallelDataProperties.getter(ParallelDataProperties::importedDataSize)).setter(ParallelDataProperties.setter(Builder::importedDataSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedDataSize").build()}).build();
    private static final SdkField<Long> IMPORTED_RECORD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ImportedRecordCount").getter(ParallelDataProperties.getter(ParallelDataProperties::importedRecordCount)).setter(ParallelDataProperties.setter(Builder::importedRecordCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedRecordCount").build()}).build();
    private static final SdkField<Long> FAILED_RECORD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FailedRecordCount").getter(ParallelDataProperties.getter(ParallelDataProperties::failedRecordCount)).setter(ParallelDataProperties.setter(Builder::failedRecordCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRecordCount").build()}).build();
    private static final SdkField<Long> SKIPPED_RECORD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SkippedRecordCount").getter(ParallelDataProperties.getter(ParallelDataProperties::skippedRecordCount)).setter(ParallelDataProperties.setter(Builder::skippedRecordCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkippedRecordCount").build()}).build();
    private static final SdkField<EncryptionKey> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionKey").getter(ParallelDataProperties.getter(ParallelDataProperties::encryptionKey)).setter(ParallelDataProperties.setter(Builder::encryptionKey)).constructor(EncryptionKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ParallelDataProperties.getter(ParallelDataProperties::createdAt)).setter(ParallelDataProperties.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(ParallelDataProperties.getter(ParallelDataProperties::lastUpdatedAt)).setter(ParallelDataProperties.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> LATEST_UPDATE_ATTEMPT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestUpdateAttemptStatus").getter(ParallelDataProperties.getter(ParallelDataProperties::latestUpdateAttemptStatusAsString)).setter(ParallelDataProperties.setter(Builder::latestUpdateAttemptStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUpdateAttemptStatus").build()}).build();
    private static final SdkField<Instant> LATEST_UPDATE_ATTEMPT_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestUpdateAttemptAt").getter(ParallelDataProperties.getter(ParallelDataProperties::latestUpdateAttemptAt)).setter(ParallelDataProperties.setter(Builder::latestUpdateAttemptAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUpdateAttemptAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODES_FIELD, PARALLEL_DATA_CONFIG_FIELD, MESSAGE_FIELD, IMPORTED_DATA_SIZE_FIELD, IMPORTED_RECORD_COUNT_FIELD, FAILED_RECORD_COUNT_FIELD, SKIPPED_RECORD_COUNT_FIELD, ENCRYPTION_KEY_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, LATEST_UPDATE_ATTEMPT_STATUS_FIELD, LATEST_UPDATE_ATTEMPT_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String description;
    private final String status;
    private final String sourceLanguageCode;
    private final List<String> targetLanguageCodes;
    private final ParallelDataConfig parallelDataConfig;
    private final String message;
    private final Long importedDataSize;
    private final Long importedRecordCount;
    private final Long failedRecordCount;
    private final Long skippedRecordCount;
    private final EncryptionKey encryptionKey;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String latestUpdateAttemptStatus;
    private final Instant latestUpdateAttemptAt;

    private ParallelDataProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.status = builder.status;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCodes = builder.targetLanguageCodes;
        this.parallelDataConfig = builder.parallelDataConfig;
        this.message = builder.message;
        this.importedDataSize = builder.importedDataSize;
        this.importedRecordCount = builder.importedRecordCount;
        this.failedRecordCount = builder.failedRecordCount;
        this.skippedRecordCount = builder.skippedRecordCount;
        this.encryptionKey = builder.encryptionKey;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.latestUpdateAttemptStatus = builder.latestUpdateAttemptStatus;
        this.latestUpdateAttemptAt = builder.latestUpdateAttemptAt;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final ParallelDataStatus status() {
        return ParallelDataStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public final boolean hasTargetLanguageCodes() {
        return this.targetLanguageCodes != null && !(this.targetLanguageCodes instanceof SdkAutoConstructList);
    }

    public final List<String> targetLanguageCodes() {
        return this.targetLanguageCodes;
    }

    public final ParallelDataConfig parallelDataConfig() {
        return this.parallelDataConfig;
    }

    public final String message() {
        return this.message;
    }

    public final Long importedDataSize() {
        return this.importedDataSize;
    }

    public final Long importedRecordCount() {
        return this.importedRecordCount;
    }

    public final Long failedRecordCount() {
        return this.failedRecordCount;
    }

    public final Long skippedRecordCount() {
        return this.skippedRecordCount;
    }

    public final EncryptionKey encryptionKey() {
        return this.encryptionKey;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final ParallelDataStatus latestUpdateAttemptStatus() {
        return ParallelDataStatus.fromValue(this.latestUpdateAttemptStatus);
    }

    public final String latestUpdateAttemptStatusAsString() {
        return this.latestUpdateAttemptStatus;
    }

    public final Instant latestUpdateAttemptAt() {
        return this.latestUpdateAttemptAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLanguageCodes() ? this.targetLanguageCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedDataSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.skippedRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestUpdateAttemptStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestUpdateAttemptAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParallelDataProperties)) {
            return false;
        }
        ParallelDataProperties other = (ParallelDataProperties)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && this.hasTargetLanguageCodes() == other.hasTargetLanguageCodes() && Objects.equals(this.targetLanguageCodes(), other.targetLanguageCodes()) && Objects.equals(this.parallelDataConfig(), other.parallelDataConfig()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.importedDataSize(), other.importedDataSize()) && Objects.equals(this.importedRecordCount(), other.importedRecordCount()) && Objects.equals(this.failedRecordCount(), other.failedRecordCount()) && Objects.equals(this.skippedRecordCount(), other.skippedRecordCount()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.latestUpdateAttemptStatusAsString(), other.latestUpdateAttemptStatusAsString()) && Objects.equals(this.latestUpdateAttemptAt(), other.latestUpdateAttemptAt());
    }

    public final String toString() {
        return ToString.builder((String)"ParallelDataProperties").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCodes", this.hasTargetLanguageCodes() ? this.targetLanguageCodes() : null).add("ParallelDataConfig", (Object)this.parallelDataConfig()).add("Message", (Object)this.message()).add("ImportedDataSize", (Object)this.importedDataSize()).add("ImportedRecordCount", (Object)this.importedRecordCount()).add("FailedRecordCount", (Object)this.failedRecordCount()).add("SkippedRecordCount", (Object)this.skippedRecordCount()).add("EncryptionKey", (Object)this.encryptionKey()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LatestUpdateAttemptStatus", (Object)this.latestUpdateAttemptStatusAsString()).add("LatestUpdateAttemptAt", (Object)this.latestUpdateAttemptAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SourceLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCodes": {
                return Optional.ofNullable(clazz.cast(this.targetLanguageCodes()));
            }
            case "ParallelDataConfig": {
                return Optional.ofNullable(clazz.cast(this.parallelDataConfig()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ImportedDataSize": {
                return Optional.ofNullable(clazz.cast(this.importedDataSize()));
            }
            case "ImportedRecordCount": {
                return Optional.ofNullable(clazz.cast(this.importedRecordCount()));
            }
            case "FailedRecordCount": {
                return Optional.ofNullable(clazz.cast(this.failedRecordCount()));
            }
            case "SkippedRecordCount": {
                return Optional.ofNullable(clazz.cast(this.skippedRecordCount()));
            }
            case "EncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "LatestUpdateAttemptStatus": {
                return Optional.ofNullable(clazz.cast(this.latestUpdateAttemptStatusAsString()));
            }
            case "LatestUpdateAttemptAt": {
                return Optional.ofNullable(clazz.cast(this.latestUpdateAttemptAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParallelDataProperties, T> g) {
        return obj -> g.apply((ParallelDataProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String description;
        private String status;
        private String sourceLanguageCode;
        private List<String> targetLanguageCodes = DefaultSdkAutoConstructList.getInstance();
        private ParallelDataConfig parallelDataConfig;
        private String message;
        private Long importedDataSize;
        private Long importedRecordCount;
        private Long failedRecordCount;
        private Long skippedRecordCount;
        private EncryptionKey encryptionKey;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String latestUpdateAttemptStatus;
        private Instant latestUpdateAttemptAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ParallelDataProperties model) {
            this.name(model.name);
            this.arn(model.arn);
            this.description(model.description);
            this.status(model.status);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCodes(model.targetLanguageCodes);
            this.parallelDataConfig(model.parallelDataConfig);
            this.message(model.message);
            this.importedDataSize(model.importedDataSize);
            this.importedRecordCount(model.importedRecordCount);
            this.failedRecordCount(model.failedRecordCount);
            this.skippedRecordCount(model.skippedRecordCount);
            this.encryptionKey(model.encryptionKey);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.latestUpdateAttemptStatus(model.latestUpdateAttemptStatus);
            this.latestUpdateAttemptAt(model.latestUpdateAttemptAt);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ParallelDataStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final Collection<String> getTargetLanguageCodes() {
            if (this.targetLanguageCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetLanguageCodes;
        }

        @Override
        public final Builder targetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = LanguageCodeStringListCopier.copy(targetLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLanguageCodes(String ... targetLanguageCodes) {
            this.targetLanguageCodes(Arrays.asList(targetLanguageCodes));
            return this;
        }

        public final void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = LanguageCodeStringListCopier.copy(targetLanguageCodes);
        }

        public final ParallelDataConfig.Builder getParallelDataConfig() {
            return this.parallelDataConfig != null ? this.parallelDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder parallelDataConfig(ParallelDataConfig parallelDataConfig) {
            this.parallelDataConfig = parallelDataConfig;
            return this;
        }

        public final void setParallelDataConfig(ParallelDataConfig.BuilderImpl parallelDataConfig) {
            this.parallelDataConfig = parallelDataConfig != null ? parallelDataConfig.build() : null;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getImportedDataSize() {
            return this.importedDataSize;
        }

        @Override
        public final Builder importedDataSize(Long importedDataSize) {
            this.importedDataSize = importedDataSize;
            return this;
        }

        public final void setImportedDataSize(Long importedDataSize) {
            this.importedDataSize = importedDataSize;
        }

        public final Long getImportedRecordCount() {
            return this.importedRecordCount;
        }

        @Override
        public final Builder importedRecordCount(Long importedRecordCount) {
            this.importedRecordCount = importedRecordCount;
            return this;
        }

        public final void setImportedRecordCount(Long importedRecordCount) {
            this.importedRecordCount = importedRecordCount;
        }

        public final Long getFailedRecordCount() {
            return this.failedRecordCount;
        }

        @Override
        public final Builder failedRecordCount(Long failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
            return this;
        }

        public final void setFailedRecordCount(Long failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
        }

        public final Long getSkippedRecordCount() {
            return this.skippedRecordCount;
        }

        @Override
        public final Builder skippedRecordCount(Long skippedRecordCount) {
            this.skippedRecordCount = skippedRecordCount;
            return this;
        }

        public final void setSkippedRecordCount(Long skippedRecordCount) {
            this.skippedRecordCount = skippedRecordCount;
        }

        public final EncryptionKey.Builder getEncryptionKey() {
            return this.encryptionKey != null ? this.encryptionKey.toBuilder() : null;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(EncryptionKey.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getLatestUpdateAttemptStatus() {
            return this.latestUpdateAttemptStatus;
        }

        @Override
        public final Builder latestUpdateAttemptStatus(String latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus = latestUpdateAttemptStatus;
            return this;
        }

        @Override
        public final Builder latestUpdateAttemptStatus(ParallelDataStatus latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus(latestUpdateAttemptStatus == null ? null : latestUpdateAttemptStatus.toString());
            return this;
        }

        public final void setLatestUpdateAttemptStatus(String latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus = latestUpdateAttemptStatus;
        }

        public final Instant getLatestUpdateAttemptAt() {
            return this.latestUpdateAttemptAt;
        }

        @Override
        public final Builder latestUpdateAttemptAt(Instant latestUpdateAttemptAt) {
            this.latestUpdateAttemptAt = latestUpdateAttemptAt;
            return this;
        }

        public final void setLatestUpdateAttemptAt(Instant latestUpdateAttemptAt) {
            this.latestUpdateAttemptAt = latestUpdateAttemptAt;
        }

        public ParallelDataProperties build() {
            return new ParallelDataProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParallelDataProperties> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ParallelDataStatus var1);

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCodes(Collection<String> var1);

        public Builder targetLanguageCodes(String ... var1);

        public Builder parallelDataConfig(ParallelDataConfig var1);

        default public Builder parallelDataConfig(Consumer<ParallelDataConfig.Builder> parallelDataConfig) {
            return this.parallelDataConfig((ParallelDataConfig)((ParallelDataConfig.Builder)ParallelDataConfig.builder().applyMutation(parallelDataConfig)).build());
        }

        public Builder message(String var1);

        public Builder importedDataSize(Long var1);

        public Builder importedRecordCount(Long var1);

        public Builder failedRecordCount(Long var1);

        public Builder skippedRecordCount(Long var1);

        public Builder encryptionKey(EncryptionKey var1);

        default public Builder encryptionKey(Consumer<EncryptionKey.Builder> encryptionKey) {
            return this.encryptionKey((EncryptionKey)((EncryptionKey.Builder)EncryptionKey.builder().applyMutation(encryptionKey)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder latestUpdateAttemptStatus(String var1);

        public Builder latestUpdateAttemptStatus(ParallelDataStatus var1);

        public Builder latestUpdateAttemptAt(Instant var1);
    }
}

