/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.InputDataConfig;
import software.amazon.awssdk.services.translate.model.JobDetails;
import software.amazon.awssdk.services.translate.model.JobStatus;
import software.amazon.awssdk.services.translate.model.OutputDataConfig;
import software.amazon.awssdk.services.translate.model.ResourceNameListCopier;
import software.amazon.awssdk.services.translate.model.TargetLanguageCodeStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextTranslationJobProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextTranslationJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::jobId)).setter(TextTranslationJobProperties.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::jobName)).setter(TextTranslationJobProperties.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::jobStatusAsString)).setter(TextTranslationJobProperties.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<JobDetails> JOB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobDetails").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::jobDetails)).setter(TextTranslationJobProperties.setter(Builder::jobDetails)).constructor(JobDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDetails").build()}).build();
    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLanguageCode").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::sourceLanguageCode)).setter(TextTranslationJobProperties.setter(Builder::sourceLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build()}).build();
    private static final SdkField<List<String>> TARGET_LANGUAGE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLanguageCodes").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::targetLanguageCodes)).setter(TextTranslationJobProperties.setter(Builder::targetLanguageCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TERMINOLOGY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TerminologyNames").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::terminologyNames)).setter(TextTranslationJobProperties.setter(Builder::terminologyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PARALLEL_DATA_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParallelDataNames").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::parallelDataNames)).setter(TextTranslationJobProperties.setter(Builder::parallelDataNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::message)).setter(TextTranslationJobProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> SUBMITTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmittedTime").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::submittedTime)).setter(TextTranslationJobProperties.setter(Builder::submittedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::endTime)).setter(TextTranslationJobProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::inputDataConfig)).setter(TextTranslationJobProperties.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::outputDataConfig)).setter(TextTranslationJobProperties.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(TextTranslationJobProperties.getter(TextTranslationJobProperties::dataAccessRoleArn)).setter(TextTranslationJobProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD, JOB_STATUS_FIELD, JOB_DETAILS_FIELD, SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODES_FIELD, TERMINOLOGY_NAMES_FIELD, PARALLEL_DATA_NAMES_FIELD, MESSAGE_FIELD, SUBMITTED_TIME_FIELD, END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String jobName;
    private final String jobStatus;
    private final JobDetails jobDetails;
    private final String sourceLanguageCode;
    private final List<String> targetLanguageCodes;
    private final List<String> terminologyNames;
    private final List<String> parallelDataNames;
    private final String message;
    private final Instant submittedTime;
    private final Instant endTime;
    private final InputDataConfig inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final String dataAccessRoleArn;

    private TextTranslationJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.jobDetails = builder.jobDetails;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCodes = builder.targetLanguageCodes;
        this.terminologyNames = builder.terminologyNames;
        this.parallelDataNames = builder.parallelDataNames;
        this.message = builder.message;
        this.submittedTime = builder.submittedTime;
        this.endTime = builder.endTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobName() {
        return this.jobName;
    }

    public JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public JobDetails jobDetails() {
        return this.jobDetails;
    }

    public String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public boolean hasTargetLanguageCodes() {
        return this.targetLanguageCodes != null && !(this.targetLanguageCodes instanceof SdkAutoConstructList);
    }

    public List<String> targetLanguageCodes() {
        return this.targetLanguageCodes;
    }

    public boolean hasTerminologyNames() {
        return this.terminologyNames != null && !(this.terminologyNames instanceof SdkAutoConstructList);
    }

    public List<String> terminologyNames() {
        return this.terminologyNames;
    }

    public boolean hasParallelDataNames() {
        return this.parallelDataNames != null && !(this.parallelDataNames instanceof SdkAutoConstructList);
    }

    public List<String> parallelDataNames() {
        return this.parallelDataNames;
    }

    public String message() {
        return this.message;
    }

    public Instant submittedTime() {
        return this.submittedTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLanguageCodes() ? this.targetLanguageCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerminologyNames() ? this.terminologyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParallelDataNames() ? this.parallelDataNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextTranslationJobProperties)) {
            return false;
        }
        TextTranslationJobProperties other = (TextTranslationJobProperties)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.jobDetails(), other.jobDetails()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && this.hasTargetLanguageCodes() == other.hasTargetLanguageCodes() && Objects.equals(this.targetLanguageCodes(), other.targetLanguageCodes()) && this.hasTerminologyNames() == other.hasTerminologyNames() && Objects.equals(this.terminologyNames(), other.terminologyNames()) && this.hasParallelDataNames() == other.hasParallelDataNames() && Objects.equals(this.parallelDataNames(), other.parallelDataNames()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.submittedTime(), other.submittedTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"TextTranslationJobProperties").add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("JobDetails", (Object)this.jobDetails()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCodes", this.hasTargetLanguageCodes() ? this.targetLanguageCodes() : null).add("TerminologyNames", this.hasTerminologyNames() ? this.terminologyNames() : null).add("ParallelDataNames", this.hasParallelDataNames() ? this.parallelDataNames() : null).add("Message", (Object)this.message()).add("SubmittedTime", (Object)this.submittedTime()).add("EndTime", (Object)this.endTime()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "JobDetails": {
                return Optional.ofNullable(clazz.cast(this.jobDetails()));
            }
            case "SourceLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCodes": {
                return Optional.ofNullable(clazz.cast(this.targetLanguageCodes()));
            }
            case "TerminologyNames": {
                return Optional.ofNullable(clazz.cast(this.terminologyNames()));
            }
            case "ParallelDataNames": {
                return Optional.ofNullable(clazz.cast(this.parallelDataNames()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "SubmittedTime": {
                return Optional.ofNullable(clazz.cast(this.submittedTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextTranslationJobProperties, T> g) {
        return obj -> g.apply((TextTranslationJobProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobName;
        private String jobStatus;
        private JobDetails jobDetails;
        private String sourceLanguageCode;
        private List<String> targetLanguageCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> terminologyNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> parallelDataNames = DefaultSdkAutoConstructList.getInstance();
        private String message;
        private Instant submittedTime;
        private Instant endTime;
        private InputDataConfig inputDataConfig;
        private OutputDataConfig outputDataConfig;
        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TextTranslationJobProperties model) {
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.jobDetails(model.jobDetails);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCodes(model.targetLanguageCodes);
            this.terminologyNames(model.terminologyNames);
            this.parallelDataNames(model.parallelDataNames);
            this.message(model.message);
            this.submittedTime(model.submittedTime);
            this.endTime(model.endTime);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final JobDetails.Builder getJobDetails() {
            return this.jobDetails != null ? this.jobDetails.toBuilder() : null;
        }

        @Override
        public final Builder jobDetails(JobDetails jobDetails) {
            this.jobDetails = jobDetails;
            return this;
        }

        public final void setJobDetails(JobDetails.BuilderImpl jobDetails) {
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final Collection<String> getTargetLanguageCodes() {
            if (this.targetLanguageCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetLanguageCodes;
        }

        @Override
        public final Builder targetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = TargetLanguageCodeStringListCopier.copy(targetLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLanguageCodes(String ... targetLanguageCodes) {
            this.targetLanguageCodes(Arrays.asList(targetLanguageCodes));
            return this;
        }

        public final void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = TargetLanguageCodeStringListCopier.copy(targetLanguageCodes);
        }

        public final Collection<String> getTerminologyNames() {
            if (this.terminologyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.terminologyNames;
        }

        @Override
        public final Builder terminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminologyNames(String ... terminologyNames) {
            this.terminologyNames(Arrays.asList(terminologyNames));
            return this;
        }

        public final void setTerminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
        }

        public final Collection<String> getParallelDataNames() {
            if (this.parallelDataNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parallelDataNames;
        }

        @Override
        public final Builder parallelDataNames(Collection<String> parallelDataNames) {
            this.parallelDataNames = ResourceNameListCopier.copy(parallelDataNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parallelDataNames(String ... parallelDataNames) {
            this.parallelDataNames(Arrays.asList(parallelDataNames));
            return this;
        }

        public final void setParallelDataNames(Collection<String> parallelDataNames) {
            this.parallelDataNames = ResourceNameListCopier.copy(parallelDataNames);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getSubmittedTime() {
            return this.submittedTime;
        }

        @Override
        public final Builder submittedTime(Instant submittedTime) {
            this.submittedTime = submittedTime;
            return this;
        }

        public final void setSubmittedTime(Instant submittedTime) {
            this.submittedTime = submittedTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public TextTranslationJobProperties build() {
            return new TextTranslationJobProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextTranslationJobProperties> {
        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder jobDetails(JobDetails var1);

        default public Builder jobDetails(Consumer<JobDetails.Builder> jobDetails) {
            return this.jobDetails((JobDetails)((JobDetails.Builder)JobDetails.builder().applyMutation(jobDetails)).build());
        }

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCodes(Collection<String> var1);

        public Builder targetLanguageCodes(String ... var1);

        public Builder terminologyNames(Collection<String> var1);

        public Builder terminologyNames(String ... var1);

        public Builder parallelDataNames(Collection<String> var1);

        public Builder parallelDataNames(String ... var1);

        public Builder message(String var1);

        public Builder submittedTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder dataAccessRoleArn(String var1);
    }
}

