/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.translate.DefaultTranslateClientBuilder;
import software.amazon.awssdk.services.translate.TranslateClientBuilder;
import software.amazon.awssdk.services.translate.model.DetectedLanguageLowConfidenceException;
import software.amazon.awssdk.services.translate.model.InternalServerException;
import software.amazon.awssdk.services.translate.model.InvalidRequestException;
import software.amazon.awssdk.services.translate.model.ServiceUnavailableException;
import software.amazon.awssdk.services.translate.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.translate.model.TooManyRequestsException;
import software.amazon.awssdk.services.translate.model.TranslateException;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.services.translate.model.TranslateTextResponse;
import software.amazon.awssdk.services.translate.model.UnsupportedLanguagePairException;

public interface TranslateClient
extends SdkClient {
    public static final String SERVICE_NAME = "translate";

    public static TranslateClient create() {
        return (TranslateClient)TranslateClient.builder().build();
    }

    public static TranslateClientBuilder builder() {
        return new DefaultTranslateClientBuilder();
    }

    default public TranslateTextResponse translateText(TranslateTextRequest translateTextRequest) throws InvalidRequestException, TextSizeLimitExceededException, TooManyRequestsException, UnsupportedLanguagePairException, DetectedLanguageLowConfidenceException, InternalServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    default public TranslateTextResponse translateText(Consumer<TranslateTextRequest.Builder> translateTextRequest) throws InvalidRequestException, TextSizeLimitExceededException, TooManyRequestsException, UnsupportedLanguagePairException, DetectedLanguageLowConfidenceException, InternalServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, TranslateException {
        return this.translateText((TranslateTextRequest)((Object)((TranslateTextRequest.Builder)TranslateTextRequest.builder().applyMutation(translateTextRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

