/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TranslateTextRequestModelMarshaller {
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCELANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceLanguageCode").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETLANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetLanguageCode").isBinary(false).build();
    private static final TranslateTextRequestModelMarshaller INSTANCE = new TranslateTextRequestModelMarshaller();

    private TranslateTextRequestModelMarshaller() {
    }

    public static TranslateTextRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TranslateTextRequest translateTextRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)translateTextRequest), (String)"translateTextRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)translateTextRequest.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)translateTextRequest.sourceLanguageCode(), SOURCELANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)translateTextRequest.targetLanguageCode(), TARGETLANGUAGECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

