/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the endpoint configuration for a web app, including VPC settings when the endpoint is hosted within a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebAppEndpointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<WebAppEndpointDetails.Builder, WebAppEndpointDetails> {
    private static final SdkField<WebAppVpcConfig> VPC_FIELD = SdkField.<WebAppVpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("Vpc").getter(getter(WebAppEndpointDetails::vpc)).setter(setter(Builder::vpc))
            .constructor(WebAppVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WebAppVpcConfig vpc;

    private final Type type;

    private WebAppEndpointDetails(BuilderImpl builder) {
        this.vpc = builder.vpc;
        this.type = builder.type;
    }

    /**
     * <p>
     * The VPC configuration for hosting the web app endpoint within a VPC.
     * </p>
     * 
     * @return The VPC configuration for hosting the web app endpoint within a VPC.
     */
    public final WebAppVpcConfig vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebAppEndpointDetails)) {
            return false;
        }
        WebAppEndpointDetails other = (WebAppEndpointDetails) obj;
        return Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebAppEndpointDetails").add("Vpc", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #vpc()} initialized to the given value.
     *
     * <p>
     * The VPC configuration for hosting the web app endpoint within a VPC.
     * </p>
     * 
     * @param vpc
     *        The VPC configuration for hosting the web app endpoint within a VPC.
     */
    public static WebAppEndpointDetails fromVpc(WebAppVpcConfig vpc) {
        return builder().vpc(vpc).build();
    }

    /**
     * Create an instance of this class with {@link #vpc()} initialized to the given value.
     *
     * <p>
     * The VPC configuration for hosting the web app endpoint within a VPC.
     * </p>
     * 
     * @param vpc
     *        The VPC configuration for hosting the web app endpoint within a VPC.
     */
    public static WebAppEndpointDetails fromVpc(Consumer<WebAppVpcConfig.Builder> vpc) {
        WebAppVpcConfig.Builder builder = WebAppVpcConfig.builder();
        vpc.accept(builder);
        return fromVpc(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Vpc", VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebAppEndpointDetails, T> g) {
        return obj -> g.apply((WebAppEndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebAppEndpointDetails> {
        /**
         * <p>
         * The VPC configuration for hosting the web app endpoint within a VPC.
         * </p>
         * 
         * @param vpc
         *        The VPC configuration for hosting the web app endpoint within a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(WebAppVpcConfig vpc);

        /**
         * <p>
         * The VPC configuration for hosting the web app endpoint within a VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebAppVpcConfig.Builder} avoiding the
         * need to create one manually via {@link WebAppVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebAppVpcConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #vpc(WebAppVpcConfig)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link WebAppVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(WebAppVpcConfig)
         */
        default Builder vpc(Consumer<WebAppVpcConfig.Builder> vpc) {
            return vpc(WebAppVpcConfig.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WebAppVpcConfig vpc;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WebAppEndpointDetails model) {
            vpc(model.vpc);
        }

        public final WebAppVpcConfig.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(WebAppVpcConfig.BuilderImpl vpc) {
            Object oldValue = this.vpc;
            this.vpc = vpc != null ? vpc.build() : null;
            handleUnionValueChange(Type.VPC, oldValue, this.vpc);
        }

        @Override
        public final Builder vpc(WebAppVpcConfig vpc) {
            Object oldValue = this.vpc;
            this.vpc = vpc;
            handleUnionValueChange(Type.VPC, oldValue, this.vpc);
            return this;
        }

        @Override
        public WebAppEndpointDetails build() {
            return new WebAppEndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see WebAppEndpointDetails#type()
     */
    public enum Type {
        VPC,

        UNKNOWN_TO_SDK_VERSION
    }
}
