/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCertificateRequest extends TransferRequest implements
        ToCopyableBuilder<UpdateCertificateRequest.Builder, UpdateCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateId").getter(getter(UpdateCertificateRequest::certificateId))
            .setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<Instant> ACTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ActiveDate").getter(getter(UpdateCertificateRequest::activeDate)).setter(setter(Builder::activeDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDate").build()).build();

    private static final SdkField<Instant> INACTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InactiveDate").getter(getter(UpdateCertificateRequest::inactiveDate))
            .setter(setter(Builder::inactiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InactiveDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateCertificateRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            ACTIVE_DATE_FIELD, INACTIVE_DATE_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificateId;

    private final Instant activeDate;

    private final Instant inactiveDate;

    private final String description;

    private UpdateCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.activeDate = builder.activeDate;
        this.inactiveDate = builder.inactiveDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The identifier of the certificate object that you are updating.
     * </p>
     * 
     * @return The identifier of the certificate object that you are updating.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * An optional date that specifies when the certificate becomes active. If you do not specify a value,
     * <code>ActiveDate</code> takes the same value as <code>NotBeforeDate</code>, which is specified by the CA.
     * </p>
     * 
     * @return An optional date that specifies when the certificate becomes active. If you do not specify a value,
     *         <code>ActiveDate</code> takes the same value as <code>NotBeforeDate</code>, which is specified by the CA.
     */
    public final Instant activeDate() {
        return activeDate;
    }

    /**
     * <p>
     * An optional date that specifies when the certificate becomes inactive. If you do not specify a value,
     * <code>InactiveDate</code> takes the same value as <code>NotAfterDate</code>, which is specified by the CA.
     * </p>
     * 
     * @return An optional date that specifies when the certificate becomes inactive. If you do not specify a value,
     *         <code>InactiveDate</code> takes the same value as <code>NotAfterDate</code>, which is specified by the
     *         CA.
     */
    public final Instant inactiveDate() {
        return inactiveDate;
    }

    /**
     * <p>
     * A short description to help identify the certificate.
     * </p>
     * 
     * @return A short description to help identify the certificate.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(activeDate());
        hashCode = 31 * hashCode + Objects.hashCode(inactiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateRequest)) {
            return false;
        }
        UpdateCertificateRequest other = (UpdateCertificateRequest) obj;
        return Objects.equals(certificateId(), other.certificateId()) && Objects.equals(activeDate(), other.activeDate())
                && Objects.equals(inactiveDate(), other.inactiveDate()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCertificateRequest").add("CertificateId", certificateId()).add("ActiveDate", activeDate())
                .add("InactiveDate", inactiveDate()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "ActiveDate":
            return Optional.ofNullable(clazz.cast(activeDate()));
        case "InactiveDate":
            return Optional.ofNullable(clazz.cast(inactiveDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateId", CERTIFICATE_ID_FIELD);
        map.put("ActiveDate", ACTIVE_DATE_FIELD);
        map.put("InactiveDate", INACTIVE_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCertificateRequest, T> g) {
        return obj -> g.apply((UpdateCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCertificateRequest> {
        /**
         * <p>
         * The identifier of the certificate object that you are updating.
         * </p>
         * 
         * @param certificateId
         *        The identifier of the certificate object that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * An optional date that specifies when the certificate becomes active. If you do not specify a value,
         * <code>ActiveDate</code> takes the same value as <code>NotBeforeDate</code>, which is specified by the CA.
         * </p>
         * 
         * @param activeDate
         *        An optional date that specifies when the certificate becomes active. If you do not specify a value,
         *        <code>ActiveDate</code> takes the same value as <code>NotBeforeDate</code>, which is specified by the
         *        CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDate(Instant activeDate);

        /**
         * <p>
         * An optional date that specifies when the certificate becomes inactive. If you do not specify a value,
         * <code>InactiveDate</code> takes the same value as <code>NotAfterDate</code>, which is specified by the CA.
         * </p>
         * 
         * @param inactiveDate
         *        An optional date that specifies when the certificate becomes inactive. If you do not specify a value,
         *        <code>InactiveDate</code> takes the same value as <code>NotAfterDate</code>, which is specified by the
         *        CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inactiveDate(Instant inactiveDate);

        /**
         * <p>
         * A short description to help identify the certificate.
         * </p>
         * 
         * @param description
         *        A short description to help identify the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String certificateId;

        private Instant activeDate;

        private Instant inactiveDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateRequest model) {
            super(model);
            certificateId(model.certificateId);
            activeDate(model.activeDate);
            inactiveDate(model.inactiveDate);
            description(model.description);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final Instant getActiveDate() {
            return activeDate;
        }

        public final void setActiveDate(Instant activeDate) {
            this.activeDate = activeDate;
        }

        @Override
        public final Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Instant getInactiveDate() {
            return inactiveDate;
        }

        public final void setInactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
        }

        @Override
        public final Builder inactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCertificateRequest build() {
            return new UpdateCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
