/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestIdentityProviderResponse extends TransferResponse implements
        ToCopyableBuilder<TestIdentityProviderResponse.Builder, TestIdentityProviderResponse> {
    private static final SdkField<String> RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Response").getter(getter(TestIdentityProviderResponse::response)).setter(setter(Builder::response))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Response").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(TestIdentityProviderResponse::statusCode))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(TestIdentityProviderResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(TestIdentityProviderResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_FIELD,
            STATUS_CODE_FIELD, MESSAGE_FIELD, URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String response;

    private final Integer statusCode;

    private final String message;

    private final String url;

    private TestIdentityProviderResponse(BuilderImpl builder) {
        super(builder);
        this.response = builder.response;
        this.statusCode = builder.statusCode;
        this.message = builder.message;
        this.url = builder.url;
    }

    /**
     * <p>
     * The response that is returned from your API Gateway or your Lambda function.
     * </p>
     * 
     * @return The response that is returned from your API Gateway or your Lambda function.
     */
    public final String response() {
        return response;
    }

    /**
     * <p>
     * The HTTP status code that is the response from your API Gateway or your Lambda function.
     * </p>
     * 
     * @return The HTTP status code that is the response from your API Gateway or your Lambda function.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * A message that indicates whether the test was successful or not.
     * </p>
     * <note>
     * <p>
     * If an empty string is returned, the most likely cause is that the authentication failed due to an incorrect
     * username or password.
     * </p>
     * </note>
     * 
     * @return A message that indicates whether the test was successful or not.</p> <note>
     *         <p>
     *         If an empty string is returned, the most likely cause is that the authentication failed due to an
     *         incorrect username or password.
     *         </p>
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The endpoint of the service used to authenticate a user.
     * </p>
     * 
     * @return The endpoint of the service used to authenticate a user.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(response());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestIdentityProviderResponse)) {
            return false;
        }
        TestIdentityProviderResponse other = (TestIdentityProviderResponse) obj;
        return Objects.equals(response(), other.response()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(message(), other.message()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestIdentityProviderResponse").add("Response", response()).add("StatusCode", statusCode())
                .add("Message", message()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Response":
            return Optional.ofNullable(clazz.cast(response()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Response", RESPONSE_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("Url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestIdentityProviderResponse, T> g) {
        return obj -> g.apply((TestIdentityProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestIdentityProviderResponse> {
        /**
         * <p>
         * The response that is returned from your API Gateway or your Lambda function.
         * </p>
         * 
         * @param response
         *        The response that is returned from your API Gateway or your Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder response(String response);

        /**
         * <p>
         * The HTTP status code that is the response from your API Gateway or your Lambda function.
         * </p>
         * 
         * @param statusCode
         *        The HTTP status code that is the response from your API Gateway or your Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * A message that indicates whether the test was successful or not.
         * </p>
         * <note>
         * <p>
         * If an empty string is returned, the most likely cause is that the authentication failed due to an incorrect
         * username or password.
         * </p>
         * </note>
         * 
         * @param message
         *        A message that indicates whether the test was successful or not.</p> <note>
         *        <p>
         *        If an empty string is returned, the most likely cause is that the authentication failed due to an
         *        incorrect username or password.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The endpoint of the service used to authenticate a user.
         * </p>
         * 
         * @param url
         *        The endpoint of the service used to authenticate a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String response;

        private Integer statusCode;

        private String message;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(TestIdentityProviderResponse model) {
            super(model);
            response(model.response);
            statusCode(model.statusCode);
            message(model.message);
            url(model.url);
        }

        public final String getResponse() {
            return response;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        @Override
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public TestIdentityProviderResponse build() {
            return new TestIdentityProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
