/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRemoteMoveResponse extends TransferResponse implements
        ToCopyableBuilder<StartRemoteMoveResponse.Builder, StartRemoteMoveResponse> {
    private static final SdkField<String> MOVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("MoveId")
            .getter(getter(StartRemoteMoveResponse::moveId)).setter(setter(Builder::moveId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoveId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOVE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String moveId;

    private StartRemoteMoveResponse(BuilderImpl builder) {
        super(builder);
        this.moveId = builder.moveId;
    }

    /**
     * <p>
     * Returns a unique identifier for the move/rename operation.
     * </p>
     * 
     * @return Returns a unique identifier for the move/rename operation.
     */
    public final String moveId() {
        return moveId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(moveId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRemoteMoveResponse)) {
            return false;
        }
        StartRemoteMoveResponse other = (StartRemoteMoveResponse) obj;
        return Objects.equals(moveId(), other.moveId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRemoteMoveResponse").add("MoveId", moveId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MoveId":
            return Optional.ofNullable(clazz.cast(moveId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MoveId", MOVE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRemoteMoveResponse, T> g) {
        return obj -> g.apply((StartRemoteMoveResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartRemoteMoveResponse> {
        /**
         * <p>
         * Returns a unique identifier for the move/rename operation.
         * </p>
         * 
         * @param moveId
         *        Returns a unique identifier for the move/rename operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moveId(String moveId);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String moveId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRemoteMoveResponse model) {
            super(model);
            moveId(model.moveId);
        }

        public final String getMoveId() {
            return moveId;
        }

        public final void setMoveId(String moveId) {
            this.moveId = moveId;
        }

        @Override
        public final Builder moveId(String moveId) {
            this.moveId = moveId;
            return this;
        }

        @Override
        public StartRemoteMoveResponse build() {
            return new StartRemoteMoveResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
