/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for an SFTP connector connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SftpConnectorConnectionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SftpConnectorConnectionDetails.Builder, SftpConnectorConnectionDetails> {
    private static final SdkField<String> HOST_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostKey").getter(getter(SftpConnectorConnectionDetails::hostKey)).setter(setter(Builder::hostKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hostKey;

    private SftpConnectorConnectionDetails(BuilderImpl builder) {
        this.hostKey = builder.hostKey;
    }

    /**
     * <p>
     * The SSH public key of the remote SFTP server. This is returned during the initial connection attempt when you
     * call <code>TestConnection</code>. It allows you to retrieve the valid server host key to update the connector
     * when you are unable to obtain it in advance.
     * </p>
     * 
     * @return The SSH public key of the remote SFTP server. This is returned during the initial connection attempt when
     *         you call <code>TestConnection</code>. It allows you to retrieve the valid server host key to update the
     *         connector when you are unable to obtain it in advance.
     */
    public final String hostKey() {
        return hostKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SftpConnectorConnectionDetails)) {
            return false;
        }
        SftpConnectorConnectionDetails other = (SftpConnectorConnectionDetails) obj;
        return Objects.equals(hostKey(), other.hostKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SftpConnectorConnectionDetails").add("HostKey", hostKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostKey":
            return Optional.ofNullable(clazz.cast(hostKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HostKey", HOST_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SftpConnectorConnectionDetails, T> g) {
        return obj -> g.apply((SftpConnectorConnectionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SftpConnectorConnectionDetails> {
        /**
         * <p>
         * The SSH public key of the remote SFTP server. This is returned during the initial connection attempt when you
         * call <code>TestConnection</code>. It allows you to retrieve the valid server host key to update the connector
         * when you are unable to obtain it in advance.
         * </p>
         * 
         * @param hostKey
         *        The SSH public key of the remote SFTP server. This is returned during the initial connection attempt
         *        when you call <code>TestConnection</code>. It allows you to retrieve the valid server host key to
         *        update the connector when you are unable to obtain it in advance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKey(String hostKey);
    }

    static final class BuilderImpl implements Builder {
        private String hostKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SftpConnectorConnectionDetails model) {
            hostKey(model.hostKey);
        }

        public final String getHostKey() {
            return hostKey;
        }

        public final void setHostKey(String hostKey) {
            this.hostKey = hostKey;
        }

        @Override
        public final Builder hostKey(String hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        @Override
        public SftpConnectorConnectionDetails build() {
            return new SftpConnectorConnectionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
