/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information related to the type of user authentication that is in use for a file transfer protocol-enabled
 * server's users. A server can have only one method of authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderDetails.Builder, IdentityProviderDetails> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(IdentityProviderDetails::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> INVOCATION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationRole").getter(getter(IdentityProviderDetails::invocationRole))
            .setter(setter(Builder::invocationRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRole").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(IdentityProviderDetails::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Function").getter(getter(IdentityProviderDetails::function)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()).build();

    private static final SdkField<String> SFTP_AUTHENTICATION_METHODS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SftpAuthenticationMethods").getter(getter(IdentityProviderDetails::sftpAuthenticationMethodsAsString))
            .setter(setter(Builder::sftpAuthenticationMethods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SftpAuthenticationMethods").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            INVOCATION_ROLE_FIELD, DIRECTORY_ID_FIELD, FUNCTION_FIELD, SFTP_AUTHENTICATION_METHODS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String invocationRole;

    private final String directoryId;

    private final String function;

    private final String sftpAuthenticationMethods;

    private IdentityProviderDetails(BuilderImpl builder) {
        this.url = builder.url;
        this.invocationRole = builder.invocationRole;
        this.directoryId = builder.directoryId;
        this.function = builder.function;
        this.sftpAuthenticationMethods = builder.sftpAuthenticationMethods;
    }

    /**
     * <p>
     * Provides the location of the service endpoint used to authenticate users.
     * </p>
     * 
     * @return Provides the location of the service endpoint used to authenticate users.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * This parameter is only applicable if your <code>IdentityProviderType</code> is <code>API_GATEWAY</code>. Provides
     * the type of <code>InvocationRole</code> used to authenticate the user account.
     * </p>
     * 
     * @return This parameter is only applicable if your <code>IdentityProviderType</code> is <code>API_GATEWAY</code>.
     *         Provides the type of <code>InvocationRole</code> used to authenticate the user account.
     */
    public final String invocationRole() {
        return invocationRole;
    }

    /**
     * <p>
     * The identifier of the Directory Service directory that you want to use as your identity provider.
     * </p>
     * 
     * @return The identifier of the Directory Service directory that you want to use as your identity provider.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The ARN for a Lambda function to use for the Identity provider.
     * </p>
     * 
     * @return The ARN for a Lambda function to use for the Identity provider.
     */
    public final String function() {
        return function;
    }

    /**
     * <p>
     * For SFTP-enabled servers, and for custom identity providers <i>only</i>, you can specify whether to authenticate
     * using a password, SSH key pair, or both.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PASSWORD</code> - users must provide their password to connect.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_KEY</code> - users must provide their private key to connect.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key. This is the
     * default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to connect.
     * The server checks the key first, and then if the key is valid, the system prompts for a password. If the private
     * key provided does not match the public key that is stored, authentication fails.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sftpAuthenticationMethods} will return {@link SftpAuthenticationMethods#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #sftpAuthenticationMethodsAsString}.
     * </p>
     * 
     * @return For SFTP-enabled servers, and for custom identity providers <i>only</i>, you can specify whether to
     *         authenticate using a password, SSH key pair, or both.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASSWORD</code> - users must provide their password to connect.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_KEY</code> - users must provide their private key to connect.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key.
     *         This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to
     *         connect. The server checks the key first, and then if the key is valid, the system prompts for a
     *         password. If the private key provided does not match the public key that is stored, authentication fails.
     *         </p>
     *         </li>
     * @see SftpAuthenticationMethods
     */
    public final SftpAuthenticationMethods sftpAuthenticationMethods() {
        return SftpAuthenticationMethods.fromValue(sftpAuthenticationMethods);
    }

    /**
     * <p>
     * For SFTP-enabled servers, and for custom identity providers <i>only</i>, you can specify whether to authenticate
     * using a password, SSH key pair, or both.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PASSWORD</code> - users must provide their password to connect.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_KEY</code> - users must provide their private key to connect.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key. This is the
     * default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to connect.
     * The server checks the key first, and then if the key is valid, the system prompts for a password. If the private
     * key provided does not match the public key that is stored, authentication fails.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sftpAuthenticationMethods} will return {@link SftpAuthenticationMethods#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #sftpAuthenticationMethodsAsString}.
     * </p>
     * 
     * @return For SFTP-enabled servers, and for custom identity providers <i>only</i>, you can specify whether to
     *         authenticate using a password, SSH key pair, or both.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASSWORD</code> - users must provide their password to connect.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_KEY</code> - users must provide their private key to connect.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key.
     *         This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to
     *         connect. The server checks the key first, and then if the key is valid, the system prompts for a
     *         password. If the private key provided does not match the public key that is stored, authentication fails.
     *         </p>
     *         </li>
     * @see SftpAuthenticationMethods
     */
    public final String sftpAuthenticationMethodsAsString() {
        return sftpAuthenticationMethods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(invocationRole());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(function());
        hashCode = 31 * hashCode + Objects.hashCode(sftpAuthenticationMethodsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderDetails)) {
            return false;
        }
        IdentityProviderDetails other = (IdentityProviderDetails) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(invocationRole(), other.invocationRole())
                && Objects.equals(directoryId(), other.directoryId()) && Objects.equals(function(), other.function())
                && Objects.equals(sftpAuthenticationMethodsAsString(), other.sftpAuthenticationMethodsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderDetails").add("Url", url()).add("InvocationRole", invocationRole())
                .add("DirectoryId", directoryId()).add("Function", function())
                .add("SftpAuthenticationMethods", sftpAuthenticationMethodsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "InvocationRole":
            return Optional.ofNullable(clazz.cast(invocationRole()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Function":
            return Optional.ofNullable(clazz.cast(function()));
        case "SftpAuthenticationMethods":
            return Optional.ofNullable(clazz.cast(sftpAuthenticationMethodsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("InvocationRole", INVOCATION_ROLE_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("SftpAuthenticationMethods", SFTP_AUTHENTICATION_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderDetails, T> g) {
        return obj -> g.apply((IdentityProviderDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderDetails> {
        /**
         * <p>
         * Provides the location of the service endpoint used to authenticate users.
         * </p>
         * 
         * @param url
         *        Provides the location of the service endpoint used to authenticate users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * This parameter is only applicable if your <code>IdentityProviderType</code> is <code>API_GATEWAY</code>.
         * Provides the type of <code>InvocationRole</code> used to authenticate the user account.
         * </p>
         * 
         * @param invocationRole
         *        This parameter is only applicable if your <code>IdentityProviderType</code> is
         *        <code>API_GATEWAY</code>. Provides the type of <code>InvocationRole</code> used to authenticate the
         *        user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationRole(String invocationRole);

        /**
         * <p>
         * The identifier of the Directory Service directory that you want to use as your identity provider.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the Directory Service directory that you want to use as your identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The ARN for a Lambda function to use for the Identity provider.
         * </p>
         * 
         * @param function
         *        The ARN for a Lambda function to use for the Identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder function(String function);

        /**
         * <p>
         * For SFTP-enabled servers, and for custom identity providers <i>only</i>, you can specify whether to
         * authenticate using a password, SSH key pair, or both.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PASSWORD</code> - users must provide their password to connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_KEY</code> - users must provide their private key to connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key. This is
         * the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to
         * connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If
         * the private key provided does not match the public key that is stored, authentication fails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sftpAuthenticationMethods
         *        For SFTP-enabled servers, and for custom identity providers <i>only</i>, you can specify whether to
         *        authenticate using a password, SSH key pair, or both.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASSWORD</code> - users must provide their password to connect.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_KEY</code> - users must provide their private key to connect.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key.
         *        This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to
         *        connect. The server checks the key first, and then if the key is valid, the system prompts for a
         *        password. If the private key provided does not match the public key that is stored, authentication
         *        fails.
         *        </p>
         *        </li>
         * @see SftpAuthenticationMethods
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SftpAuthenticationMethods
         */
        Builder sftpAuthenticationMethods(String sftpAuthenticationMethods);

        /**
         * <p>
         * For SFTP-enabled servers, and for custom identity providers <i>only</i>, you can specify whether to
         * authenticate using a password, SSH key pair, or both.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PASSWORD</code> - users must provide their password to connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_KEY</code> - users must provide their private key to connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key. This is
         * the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to
         * connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If
         * the private key provided does not match the public key that is stored, authentication fails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sftpAuthenticationMethods
         *        For SFTP-enabled servers, and for custom identity providers <i>only</i>, you can specify whether to
         *        authenticate using a password, SSH key pair, or both.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASSWORD</code> - users must provide their password to connect.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_KEY</code> - users must provide their private key to connect.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key.
         *        This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to
         *        connect. The server checks the key first, and then if the key is valid, the system prompts for a
         *        password. If the private key provided does not match the public key that is stored, authentication
         *        fails.
         *        </p>
         *        </li>
         * @see SftpAuthenticationMethods
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SftpAuthenticationMethods
         */
        Builder sftpAuthenticationMethods(SftpAuthenticationMethods sftpAuthenticationMethods);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String invocationRole;

        private String directoryId;

        private String function;

        private String sftpAuthenticationMethods;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderDetails model) {
            url(model.url);
            invocationRole(model.invocationRole);
            directoryId(model.directoryId);
            function(model.function);
            sftpAuthenticationMethods(model.sftpAuthenticationMethods);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getInvocationRole() {
            return invocationRole;
        }

        public final void setInvocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
        }

        @Override
        public final Builder invocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final String getSftpAuthenticationMethods() {
            return sftpAuthenticationMethods;
        }

        public final void setSftpAuthenticationMethods(String sftpAuthenticationMethods) {
            this.sftpAuthenticationMethods = sftpAuthenticationMethods;
        }

        @Override
        public final Builder sftpAuthenticationMethods(String sftpAuthenticationMethods) {
            this.sftpAuthenticationMethods = sftpAuthenticationMethods;
            return this;
        }

        @Override
        public final Builder sftpAuthenticationMethods(SftpAuthenticationMethods sftpAuthenticationMethods) {
            this.sftpAuthenticationMethods(sftpAuthenticationMethods == null ? null : sftpAuthenticationMethods.toString());
            return this;
        }

        @Override
        public IdentityProviderDetails build() {
            return new IdentityProviderDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
