/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * VPC_LATTICE egress configuration that specifies the Resource Configuration ARN and port for connecting to SFTP
 * servers through customer VPCs. Requires a valid Resource Configuration with appropriate network access.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorVpcLatticeEgressConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorVpcLatticeEgressConfig.Builder, ConnectorVpcLatticeEgressConfig> {
    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceConfigurationArn").getter(getter(ConnectorVpcLatticeEgressConfig::resourceConfigurationArn))
            .setter(setter(Builder::resourceConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfigurationArn").build())
            .build();

    private static final SdkField<Integer> PORT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PortNumber").getter(getter(ConnectorVpcLatticeEgressConfig::portNumber))
            .setter(setter(Builder::portNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_CONFIGURATION_ARN_FIELD, PORT_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceConfigurationArn;

    private final Integer portNumber;

    private ConnectorVpcLatticeEgressConfig(BuilderImpl builder) {
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.portNumber = builder.portNumber;
    }

    /**
     * <p>
     * ARN of the VPC_LATTICE Resource Configuration that defines the target SFTP server location. Must point to a valid
     * Resource Configuration in the customer's VPC with appropriate network connectivity to the SFTP server.
     * </p>
     * 
     * @return ARN of the VPC_LATTICE Resource Configuration that defines the target SFTP server location. Must point to
     *         a valid Resource Configuration in the customer's VPC with appropriate network connectivity to the SFTP
     *         server.
     */
    public final String resourceConfigurationArn() {
        return resourceConfigurationArn;
    }

    /**
     * <p>
     * Port number for connecting to the SFTP server through VPC_LATTICE. Defaults to 22 if not specified. Must match
     * the port on which the target SFTP server is listening.
     * </p>
     * 
     * @return Port number for connecting to the SFTP server through VPC_LATTICE. Defaults to 22 if not specified. Must
     *         match the port on which the target SFTP server is listening.
     */
    public final Integer portNumber() {
        return portNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(portNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorVpcLatticeEgressConfig)) {
            return false;
        }
        ConnectorVpcLatticeEgressConfig other = (ConnectorVpcLatticeEgressConfig) obj;
        return Objects.equals(resourceConfigurationArn(), other.resourceConfigurationArn())
                && Objects.equals(portNumber(), other.portNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorVpcLatticeEgressConfig").add("ResourceConfigurationArn", resourceConfigurationArn())
                .add("PortNumber", portNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceConfigurationArn":
            return Optional.ofNullable(clazz.cast(resourceConfigurationArn()));
        case "PortNumber":
            return Optional.ofNullable(clazz.cast(portNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("PortNumber", PORT_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorVpcLatticeEgressConfig, T> g) {
        return obj -> g.apply((ConnectorVpcLatticeEgressConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorVpcLatticeEgressConfig> {
        /**
         * <p>
         * ARN of the VPC_LATTICE Resource Configuration that defines the target SFTP server location. Must point to a
         * valid Resource Configuration in the customer's VPC with appropriate network connectivity to the SFTP server.
         * </p>
         * 
         * @param resourceConfigurationArn
         *        ARN of the VPC_LATTICE Resource Configuration that defines the target SFTP server location. Must point
         *        to a valid Resource Configuration in the customer's VPC with appropriate network connectivity to the
         *        SFTP server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationArn(String resourceConfigurationArn);

        /**
         * <p>
         * Port number for connecting to the SFTP server through VPC_LATTICE. Defaults to 22 if not specified. Must
         * match the port on which the target SFTP server is listening.
         * </p>
         * 
         * @param portNumber
         *        Port number for connecting to the SFTP server through VPC_LATTICE. Defaults to 22 if not specified.
         *        Must match the port on which the target SFTP server is listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portNumber(Integer portNumber);
    }

    static final class BuilderImpl implements Builder {
        private String resourceConfigurationArn;

        private Integer portNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorVpcLatticeEgressConfig model) {
            resourceConfigurationArn(model.resourceConfigurationArn);
            portNumber(model.portNumber);
        }

        public final String getResourceConfigurationArn() {
            return resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final Integer getPortNumber() {
            return portNumber;
        }

        public final void setPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
        }

        @Override
        public final Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        @Override
        public ConnectorVpcLatticeEgressConfig build() {
            return new ConnectorVpcLatticeEgressConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
