/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ExecutionStepResult;
import software.amazon.awssdk.services.transfer.model.ExecutionStepResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionResults
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionResults> {
    private static final SdkField<List<ExecutionStepResult>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Steps").getter(ExecutionResults.getter(ExecutionResults::steps)).setter(ExecutionResults.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExecutionStepResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExecutionStepResult>> ON_EXCEPTION_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnExceptionSteps").getter(ExecutionResults.getter(ExecutionResults::onExceptionSteps)).setter(ExecutionResults.setter(Builder::onExceptionSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnExceptionSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExecutionStepResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD, ON_EXCEPTION_STEPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionResults.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ExecutionStepResult> steps;
    private final List<ExecutionStepResult> onExceptionSteps;

    private ExecutionResults(BuilderImpl builder) {
        this.steps = builder.steps;
        this.onExceptionSteps = builder.onExceptionSteps;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<ExecutionStepResult> steps() {
        return this.steps;
    }

    public final boolean hasOnExceptionSteps() {
        return this.onExceptionSteps != null && !(this.onExceptionSteps instanceof SdkAutoConstructList);
    }

    public final List<ExecutionStepResult> onExceptionSteps() {
        return this.onExceptionSteps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnExceptionSteps() ? this.onExceptionSteps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionResults)) {
            return false;
        }
        ExecutionResults other = (ExecutionResults)obj;
        return this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && this.hasOnExceptionSteps() == other.hasOnExceptionSteps() && Objects.equals(this.onExceptionSteps(), other.onExceptionSteps());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionResults").add("Steps", this.hasSteps() ? this.steps() : null).add("OnExceptionSteps", this.hasOnExceptionSteps() ? this.onExceptionSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "OnExceptionSteps": {
                return Optional.ofNullable(clazz.cast(this.onExceptionSteps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ExecutionStepResult>>> map = new HashMap<String, SdkField<List<ExecutionStepResult>>>();
        map.put("Steps", STEPS_FIELD);
        map.put("OnExceptionSteps", ON_EXCEPTION_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionResults, T> g) {
        return obj -> g.apply((ExecutionResults)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ExecutionStepResult> steps = DefaultSdkAutoConstructList.getInstance();
        private List<ExecutionStepResult> onExceptionSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionResults model) {
            this.steps(model.steps);
            this.onExceptionSteps(model.onExceptionSteps);
        }

        public final List<ExecutionStepResult.Builder> getSteps() {
            List<ExecutionStepResult.Builder> result = ExecutionStepResultsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<ExecutionStepResult.BuilderImpl> steps) {
            this.steps = ExecutionStepResultsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<ExecutionStepResult> steps) {
            this.steps = ExecutionStepResultsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(ExecutionStepResult ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<ExecutionStepResult.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (ExecutionStepResult)((ExecutionStepResult.Builder)ExecutionStepResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ExecutionStepResult.Builder> getOnExceptionSteps() {
            List<ExecutionStepResult.Builder> result = ExecutionStepResultsCopier.copyToBuilder(this.onExceptionSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnExceptionSteps(Collection<ExecutionStepResult.BuilderImpl> onExceptionSteps) {
            this.onExceptionSteps = ExecutionStepResultsCopier.copyFromBuilder(onExceptionSteps);
        }

        @Override
        public final Builder onExceptionSteps(Collection<ExecutionStepResult> onExceptionSteps) {
            this.onExceptionSteps = ExecutionStepResultsCopier.copy(onExceptionSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onExceptionSteps(ExecutionStepResult ... onExceptionSteps) {
            this.onExceptionSteps(Arrays.asList(onExceptionSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onExceptionSteps(Consumer<ExecutionStepResult.Builder> ... onExceptionSteps) {
            this.onExceptionSteps(Stream.of(onExceptionSteps).map(c -> (ExecutionStepResult)((ExecutionStepResult.Builder)ExecutionStepResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExecutionResults build() {
            return new ExecutionResults(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionResults> {
        public Builder steps(Collection<ExecutionStepResult> var1);

        public Builder steps(ExecutionStepResult ... var1);

        public Builder steps(Consumer<ExecutionStepResult.Builder> ... var1);

        public Builder onExceptionSteps(Collection<ExecutionStepResult> var1);

        public Builder onExceptionSteps(ExecutionStepResult ... var1);

        public Builder onExceptionSteps(Consumer<ExecutionStepResult.Builder> ... var1);
    }
}

