/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.DescribedWebAppIdentityProviderDetails;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.WebAppUnits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedWebApp
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedWebApp> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribedWebApp.getter(DescribedWebApp::arn)).setter(DescribedWebApp.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAppId").getter(DescribedWebApp.getter(DescribedWebApp::webAppId)).setter(DescribedWebApp.setter(Builder::webAppId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()}).build();
    private static final SdkField<DescribedWebAppIdentityProviderDetails> DESCRIBED_IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DescribedIdentityProviderDetails").getter(DescribedWebApp.getter(DescribedWebApp::describedIdentityProviderDetails)).setter(DescribedWebApp.setter(Builder::describedIdentityProviderDetails)).constructor(DescribedWebAppIdentityProviderDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescribedIdentityProviderDetails").build()}).build();
    private static final SdkField<String> ACCESS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessEndpoint").getter(DescribedWebApp.getter(DescribedWebApp::accessEndpoint)).setter(DescribedWebApp.setter(Builder::accessEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoint").build()}).build();
    private static final SdkField<String> WEB_APP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAppEndpoint").getter(DescribedWebApp.getter(DescribedWebApp::webAppEndpoint)).setter(DescribedWebApp.setter(Builder::webAppEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppEndpoint").build()}).build();
    private static final SdkField<WebAppUnits> WEB_APP_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebAppUnits").getter(DescribedWebApp.getter(DescribedWebApp::webAppUnits)).setter(DescribedWebApp.setter(Builder::webAppUnits)).constructor(WebAppUnits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppUnits").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribedWebApp.getter(DescribedWebApp::tags)).setter(DescribedWebApp.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WEB_APP_ID_FIELD, DESCRIBED_IDENTITY_PROVIDER_DETAILS_FIELD, ACCESS_ENDPOINT_FIELD, WEB_APP_ENDPOINT_FIELD, WEB_APP_UNITS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribedWebApp.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String webAppId;
    private final DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails;
    private final String accessEndpoint;
    private final String webAppEndpoint;
    private final WebAppUnits webAppUnits;
    private final List<Tag> tags;

    private DescribedWebApp(BuilderImpl builder) {
        this.arn = builder.arn;
        this.webAppId = builder.webAppId;
        this.describedIdentityProviderDetails = builder.describedIdentityProviderDetails;
        this.accessEndpoint = builder.accessEndpoint;
        this.webAppEndpoint = builder.webAppEndpoint;
        this.webAppUnits = builder.webAppUnits;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String webAppId() {
        return this.webAppId;
    }

    public final DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails() {
        return this.describedIdentityProviderDetails;
    }

    public final String accessEndpoint() {
        return this.accessEndpoint;
    }

    public final String webAppEndpoint() {
        return this.webAppEndpoint;
    }

    public final WebAppUnits webAppUnits() {
        return this.webAppUnits;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(this.describedIdentityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedWebApp)) {
            return false;
        }
        DescribedWebApp other = (DescribedWebApp)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.webAppId(), other.webAppId()) && Objects.equals(this.describedIdentityProviderDetails(), other.describedIdentityProviderDetails()) && Objects.equals(this.accessEndpoint(), other.accessEndpoint()) && Objects.equals(this.webAppEndpoint(), other.webAppEndpoint()) && Objects.equals(this.webAppUnits(), other.webAppUnits()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedWebApp").add("Arn", (Object)this.arn()).add("WebAppId", (Object)this.webAppId()).add("DescribedIdentityProviderDetails", (Object)this.describedIdentityProviderDetails()).add("AccessEndpoint", (Object)this.accessEndpoint()).add("WebAppEndpoint", (Object)this.webAppEndpoint()).add("WebAppUnits", (Object)this.webAppUnits()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "WebAppId": {
                return Optional.ofNullable(clazz.cast(this.webAppId()));
            }
            case "DescribedIdentityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.describedIdentityProviderDetails()));
            }
            case "AccessEndpoint": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoint()));
            }
            case "WebAppEndpoint": {
                return Optional.ofNullable(clazz.cast(this.webAppEndpoint()));
            }
            case "WebAppUnits": {
                return Optional.ofNullable(clazz.cast(this.webAppUnits()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("WebAppId", WEB_APP_ID_FIELD);
        map.put("DescribedIdentityProviderDetails", DESCRIBED_IDENTITY_PROVIDER_DETAILS_FIELD);
        map.put("AccessEndpoint", ACCESS_ENDPOINT_FIELD);
        map.put("WebAppEndpoint", WEB_APP_ENDPOINT_FIELD);
        map.put("WebAppUnits", WEB_APP_UNITS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedWebApp, T> g) {
        return obj -> g.apply((DescribedWebApp)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String webAppId;
        private DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails;
        private String accessEndpoint;
        private String webAppEndpoint;
        private WebAppUnits webAppUnits;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedWebApp model) {
            this.arn(model.arn);
            this.webAppId(model.webAppId);
            this.describedIdentityProviderDetails(model.describedIdentityProviderDetails);
            this.accessEndpoint(model.accessEndpoint);
            this.webAppEndpoint(model.webAppEndpoint);
            this.webAppUnits(model.webAppUnits);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWebAppId() {
            return this.webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final DescribedWebAppIdentityProviderDetails.Builder getDescribedIdentityProviderDetails() {
            return this.describedIdentityProviderDetails != null ? this.describedIdentityProviderDetails.toBuilder() : null;
        }

        public final void setDescribedIdentityProviderDetails(DescribedWebAppIdentityProviderDetails.BuilderImpl describedIdentityProviderDetails) {
            this.describedIdentityProviderDetails = describedIdentityProviderDetails != null ? describedIdentityProviderDetails.build() : null;
        }

        @Override
        public final Builder describedIdentityProviderDetails(DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails) {
            this.describedIdentityProviderDetails = describedIdentityProviderDetails;
            return this;
        }

        public final String getAccessEndpoint() {
            return this.accessEndpoint;
        }

        public final void setAccessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
        }

        @Override
        public final Builder accessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
            return this;
        }

        public final String getWebAppEndpoint() {
            return this.webAppEndpoint;
        }

        public final void setWebAppEndpoint(String webAppEndpoint) {
            this.webAppEndpoint = webAppEndpoint;
        }

        @Override
        public final Builder webAppEndpoint(String webAppEndpoint) {
            this.webAppEndpoint = webAppEndpoint;
            return this;
        }

        public final WebAppUnits.Builder getWebAppUnits() {
            return this.webAppUnits != null ? this.webAppUnits.toBuilder() : null;
        }

        public final void setWebAppUnits(WebAppUnits.BuilderImpl webAppUnits) {
            this.webAppUnits = webAppUnits != null ? webAppUnits.build() : null;
        }

        @Override
        public final Builder webAppUnits(WebAppUnits webAppUnits) {
            this.webAppUnits = webAppUnits;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DescribedWebApp build() {
            return new DescribedWebApp(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedWebApp> {
        public Builder arn(String var1);

        public Builder webAppId(String var1);

        public Builder describedIdentityProviderDetails(DescribedWebAppIdentityProviderDetails var1);

        default public Builder describedIdentityProviderDetails(Consumer<DescribedWebAppIdentityProviderDetails.Builder> describedIdentityProviderDetails) {
            return this.describedIdentityProviderDetails((DescribedWebAppIdentityProviderDetails)((DescribedWebAppIdentityProviderDetails.Builder)DescribedWebAppIdentityProviderDetails.builder().applyMutation(describedIdentityProviderDetails)).build());
        }

        public Builder accessEndpoint(String var1);

        public Builder webAppEndpoint(String var1);

        public Builder webAppUnits(WebAppUnits var1);

        default public Builder webAppUnits(Consumer<WebAppUnits.Builder> webAppUnits) {
            return this.webAppUnits((WebAppUnits)((WebAppUnits.Builder)WebAppUnits.builder().applyMutation(webAppUnits)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

