/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedHostKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedHostKey> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribedHostKey.getter(DescribedHostKey::arn)).setter(DescribedHostKey.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> HOST_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKeyId").getter(DescribedHostKey.getter(DescribedHostKey::hostKeyId)).setter(DescribedHostKey.setter(Builder::hostKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyId").build()}).build();
    private static final SdkField<String> HOST_KEY_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKeyFingerprint").getter(DescribedHostKey.getter(DescribedHostKey::hostKeyFingerprint)).setter(DescribedHostKey.setter(Builder::hostKeyFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyFingerprint").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribedHostKey.getter(DescribedHostKey::description)).setter(DescribedHostKey.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribedHostKey.getter(DescribedHostKey::type)).setter(DescribedHostKey.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> DATE_IMPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateImported").getter(DescribedHostKey.getter(DescribedHostKey::dateImported)).setter(DescribedHostKey.setter(Builder::dateImported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateImported").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribedHostKey.getter(DescribedHostKey::tags)).setter(DescribedHostKey.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, HOST_KEY_ID_FIELD, HOST_KEY_FINGERPRINT_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, DATE_IMPORTED_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("HostKeyId", HOST_KEY_ID_FIELD);
            this.put("HostKeyFingerprint", HOST_KEY_FINGERPRINT_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("DateImported", DATE_IMPORTED_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String hostKeyId;
    private final String hostKeyFingerprint;
    private final String description;
    private final String type;
    private final Instant dateImported;
    private final List<Tag> tags;

    private DescribedHostKey(BuilderImpl builder) {
        this.arn = builder.arn;
        this.hostKeyId = builder.hostKeyId;
        this.hostKeyFingerprint = builder.hostKeyFingerprint;
        this.description = builder.description;
        this.type = builder.type;
        this.dateImported = builder.dateImported;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String hostKeyId() {
        return this.hostKeyId;
    }

    public final String hostKeyFingerprint() {
        return this.hostKeyFingerprint;
    }

    public final String description() {
        return this.description;
    }

    public final String type() {
        return this.type;
    }

    public final Instant dateImported() {
        return this.dateImported;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateImported());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedHostKey)) {
            return false;
        }
        DescribedHostKey other = (DescribedHostKey)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.hostKeyId(), other.hostKeyId()) && Objects.equals(this.hostKeyFingerprint(), other.hostKeyFingerprint()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.dateImported(), other.dateImported()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedHostKey").add("Arn", (Object)this.arn()).add("HostKeyId", (Object)this.hostKeyId()).add("HostKeyFingerprint", (Object)this.hostKeyFingerprint()).add("Description", (Object)this.description()).add("Type", (Object)this.type()).add("DateImported", (Object)this.dateImported()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "HostKeyId": {
                return Optional.ofNullable(clazz.cast(this.hostKeyId()));
            }
            case "HostKeyFingerprint": {
                return Optional.ofNullable(clazz.cast(this.hostKeyFingerprint()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "DateImported": {
                return Optional.ofNullable(clazz.cast(this.dateImported()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribedHostKey, T> g) {
        return obj -> g.apply((DescribedHostKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String hostKeyId;
        private String hostKeyFingerprint;
        private String description;
        private String type;
        private Instant dateImported;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedHostKey model) {
            this.arn(model.arn);
            this.hostKeyId(model.hostKeyId);
            this.hostKeyFingerprint(model.hostKeyFingerprint);
            this.description(model.description);
            this.type(model.type);
            this.dateImported(model.dateImported);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getHostKeyId() {
            return this.hostKeyId;
        }

        public final void setHostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
        }

        @Override
        public final Builder hostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
            return this;
        }

        public final String getHostKeyFingerprint() {
            return this.hostKeyFingerprint;
        }

        public final void setHostKeyFingerprint(String hostKeyFingerprint) {
            this.hostKeyFingerprint = hostKeyFingerprint;
        }

        @Override
        public final Builder hostKeyFingerprint(String hostKeyFingerprint) {
            this.hostKeyFingerprint = hostKeyFingerprint;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getDateImported() {
            return this.dateImported;
        }

        public final void setDateImported(Instant dateImported) {
            this.dateImported = dateImported;
        }

        @Override
        public final Builder dateImported(Instant dateImported) {
            this.dateImported = dateImported;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DescribedHostKey build() {
            return new DescribedHostKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedHostKey> {
        public Builder arn(String var1);

        public Builder hostKeyId(String var1);

        public Builder hostKeyFingerprint(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder dateImported(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

