/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.services.transfer.model.UpdateWebAppIdentityProviderDetails;
import software.amazon.awssdk.services.transfer.model.WebAppUnits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWebAppRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, UpdateWebAppRequest> {
    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAppId").getter(UpdateWebAppRequest.getter(UpdateWebAppRequest::webAppId)).setter(UpdateWebAppRequest.setter(Builder::webAppId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()}).build();
    private static final SdkField<UpdateWebAppIdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProviderDetails").getter(UpdateWebAppRequest.getter(UpdateWebAppRequest::identityProviderDetails)).setter(UpdateWebAppRequest.setter(Builder::identityProviderDetails)).constructor(UpdateWebAppIdentityProviderDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build()}).build();
    private static final SdkField<String> ACCESS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessEndpoint").getter(UpdateWebAppRequest.getter(UpdateWebAppRequest::accessEndpoint)).setter(UpdateWebAppRequest.setter(Builder::accessEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoint").build()}).build();
    private static final SdkField<WebAppUnits> WEB_APP_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebAppUnits").getter(UpdateWebAppRequest.getter(UpdateWebAppRequest::webAppUnits)).setter(UpdateWebAppRequest.setter(Builder::webAppUnits)).constructor(WebAppUnits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_APP_ID_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, ACCESS_ENDPOINT_FIELD, WEB_APP_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWebAppRequest.memberNameToFieldInitializer();
    private final String webAppId;
    private final UpdateWebAppIdentityProviderDetails identityProviderDetails;
    private final String accessEndpoint;
    private final WebAppUnits webAppUnits;

    private UpdateWebAppRequest(BuilderImpl builder) {
        super(builder);
        this.webAppId = builder.webAppId;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.accessEndpoint = builder.accessEndpoint;
        this.webAppUnits = builder.webAppUnits;
    }

    public final String webAppId() {
        return this.webAppId;
    }

    public final UpdateWebAppIdentityProviderDetails identityProviderDetails() {
        return this.identityProviderDetails;
    }

    public final String accessEndpoint() {
        return this.accessEndpoint;
    }

    public final WebAppUnits webAppUnits() {
        return this.webAppUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAppRequest)) {
            return false;
        }
        UpdateWebAppRequest other = (UpdateWebAppRequest)((Object)obj);
        return Objects.equals(this.webAppId(), other.webAppId()) && Objects.equals(this.identityProviderDetails(), other.identityProviderDetails()) && Objects.equals(this.accessEndpoint(), other.accessEndpoint()) && Objects.equals(this.webAppUnits(), other.webAppUnits());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWebAppRequest").add("WebAppId", (Object)this.webAppId()).add("IdentityProviderDetails", (Object)this.identityProviderDetails()).add("AccessEndpoint", (Object)this.accessEndpoint()).add("WebAppUnits", (Object)this.webAppUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebAppId": {
                return Optional.ofNullable(clazz.cast(this.webAppId()));
            }
            case "IdentityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.identityProviderDetails()));
            }
            case "AccessEndpoint": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoint()));
            }
            case "WebAppUnits": {
                return Optional.ofNullable(clazz.cast(this.webAppUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WebAppId", WEB_APP_ID_FIELD);
        map.put("IdentityProviderDetails", IDENTITY_PROVIDER_DETAILS_FIELD);
        map.put("AccessEndpoint", ACCESS_ENDPOINT_FIELD);
        map.put("WebAppUnits", WEB_APP_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAppRequest, T> g) {
        return obj -> g.apply((UpdateWebAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String webAppId;
        private UpdateWebAppIdentityProviderDetails identityProviderDetails;
        private String accessEndpoint;
        private WebAppUnits webAppUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAppRequest model) {
            super(model);
            this.webAppId(model.webAppId);
            this.identityProviderDetails(model.identityProviderDetails);
            this.accessEndpoint(model.accessEndpoint);
            this.webAppUnits(model.webAppUnits);
        }

        public final String getWebAppId() {
            return this.webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final UpdateWebAppIdentityProviderDetails.Builder getIdentityProviderDetails() {
            return this.identityProviderDetails != null ? this.identityProviderDetails.toBuilder() : null;
        }

        public final void setIdentityProviderDetails(UpdateWebAppIdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        @Override
        public final Builder identityProviderDetails(UpdateWebAppIdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final String getAccessEndpoint() {
            return this.accessEndpoint;
        }

        public final void setAccessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
        }

        @Override
        public final Builder accessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
            return this;
        }

        public final WebAppUnits.Builder getWebAppUnits() {
            return this.webAppUnits != null ? this.webAppUnits.toBuilder() : null;
        }

        public final void setWebAppUnits(WebAppUnits.BuilderImpl webAppUnits) {
            this.webAppUnits = webAppUnits != null ? webAppUnits.build() : null;
        }

        @Override
        public final Builder webAppUnits(WebAppUnits webAppUnits) {
            this.webAppUnits = webAppUnits;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebAppRequest build() {
            return new UpdateWebAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWebAppRequest> {
        public Builder webAppId(String var1);

        public Builder identityProviderDetails(UpdateWebAppIdentityProviderDetails var1);

        default public Builder identityProviderDetails(Consumer<UpdateWebAppIdentityProviderDetails.Builder> identityProviderDetails) {
            return this.identityProviderDetails((UpdateWebAppIdentityProviderDetails)((UpdateWebAppIdentityProviderDetails.Builder)UpdateWebAppIdentityProviderDetails.builder().applyMutation(identityProviderDetails)).build());
        }

        public Builder accessEndpoint(String var1);

        public Builder webAppUnits(WebAppUnits var1);

        default public Builder webAppUnits(Consumer<WebAppUnits.Builder> webAppUnits) {
            return this.webAppUnits((WebAppUnits)((WebAppUnits.Builder)WebAppUnits.builder().applyMutation(webAppUnits)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

