/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.internal.UserAgentUtils;
import software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult;
import software.amazon.awssdk.services.transfer.model.ListFileTransferResultsRequest;
import software.amazon.awssdk.services.transfer.model.ListFileTransferResultsResponse;

public class ListFileTransferResultsIterable
implements SdkIterable<ListFileTransferResultsResponse> {
    private final TransferClient client;
    private final ListFileTransferResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFileTransferResultsIterable(TransferClient client, ListFileTransferResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFileTransferResultsResponseFetcher();
    }

    public Iterator<ListFileTransferResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectorFileTransferResult> fileTransferResults() {
        Function<ListFileTransferResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fileTransferResults() != null) {
                return response.fileTransferResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFileTransferResultsResponseFetcher
    implements SyncPageFetcher<ListFileTransferResultsResponse> {
        private ListFileTransferResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListFileTransferResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFileTransferResultsResponse nextPage(ListFileTransferResultsResponse previousPage) {
            if (previousPage == null) {
                return ListFileTransferResultsIterable.this.client.listFileTransferResults(ListFileTransferResultsIterable.this.firstRequest);
            }
            return ListFileTransferResultsIterable.this.client.listFileTransferResults((ListFileTransferResultsRequest)((Object)ListFileTransferResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

