/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.internal.UserAgentUtils;
import software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult;
import software.amazon.awssdk.services.transfer.model.ListFileTransferResultsRequest;
import software.amazon.awssdk.services.transfer.model.ListFileTransferResultsResponse;

public class ListFileTransferResultsPublisher
implements SdkPublisher<ListFileTransferResultsResponse> {
    private final TransferAsyncClient client;
    private final ListFileTransferResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFileTransferResultsPublisher(TransferAsyncClient client, ListFileTransferResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFileTransferResultsPublisher(TransferAsyncClient client, ListFileTransferResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFileTransferResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFileTransferResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectorFileTransferResult> fileTransferResults() {
        Function<ListFileTransferResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fileTransferResults() != null) {
                return response.fileTransferResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFileTransferResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFileTransferResultsResponseFetcher
    implements AsyncPageFetcher<ListFileTransferResultsResponse> {
        private ListFileTransferResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListFileTransferResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFileTransferResultsResponse> nextPage(ListFileTransferResultsResponse previousPage) {
            if (previousPage == null) {
                return ListFileTransferResultsPublisher.this.client.listFileTransferResults(ListFileTransferResultsPublisher.this.firstRequest);
            }
            return ListFileTransferResultsPublisher.this.client.listFileTransferResults((ListFileTransferResultsRequest)((Object)ListFileTransferResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

