/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.transfer.DefaultTransferAsyncClient;
import software.amazon.awssdk.services.transfer.DefaultTransferBaseClientBuilder;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.TransferAsyncClientBuilder;
import software.amazon.awssdk.services.transfer.TransferServiceClientConfiguration;
import software.amazon.awssdk.services.transfer.endpoints.TransferEndpointProvider;

@SdkInternalApi
final class DefaultTransferAsyncClientBuilder
extends DefaultTransferBaseClientBuilder<TransferAsyncClientBuilder, TransferAsyncClient>
implements TransferAsyncClientBuilder {
    DefaultTransferAsyncClientBuilder() {
    }

    @Override
    public DefaultTransferAsyncClientBuilder endpointProvider(TransferEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TransferAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultTransferAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        TransferServiceClientConfiguration serviceClientConfiguration = TransferServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultTransferAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

