/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.CertificateStatusType;
import software.amazon.awssdk.services.transfer.model.CertificateType;
import software.amazon.awssdk.services.transfer.model.CertificateUsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedCertificate> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListedCertificate.getter(ListedCertificate::arn)).setter(ListedCertificate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateId").getter(ListedCertificate.getter(ListedCertificate::certificateId)).setter(ListedCertificate.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()}).build();
    private static final SdkField<String> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Usage").getter(ListedCertificate.getter(ListedCertificate::usageAsString)).setter(ListedCertificate.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListedCertificate.getter(ListedCertificate::statusAsString)).setter(ListedCertificate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> ACTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActiveDate").getter(ListedCertificate.getter(ListedCertificate::activeDate)).setter(ListedCertificate.setter(Builder::activeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDate").build()}).build();
    private static final SdkField<Instant> INACTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InactiveDate").getter(ListedCertificate.getter(ListedCertificate::inactiveDate)).setter(ListedCertificate.setter(Builder::inactiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InactiveDate").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ListedCertificate.getter(ListedCertificate::typeAsString)).setter(ListedCertificate.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListedCertificate.getter(ListedCertificate::description)).setter(ListedCertificate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CERTIFICATE_ID_FIELD, USAGE_FIELD, STATUS_FIELD, ACTIVE_DATE_FIELD, INACTIVE_DATE_FIELD, TYPE_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String certificateId;
    private final String usage;
    private final String status;
    private final Instant activeDate;
    private final Instant inactiveDate;
    private final String type;
    private final String description;

    private ListedCertificate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateId = builder.certificateId;
        this.usage = builder.usage;
        this.status = builder.status;
        this.activeDate = builder.activeDate;
        this.inactiveDate = builder.inactiveDate;
        this.type = builder.type;
        this.description = builder.description;
    }

    public final String arn() {
        return this.arn;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final CertificateUsageType usage() {
        return CertificateUsageType.fromValue(this.usage);
    }

    public final String usageAsString() {
        return this.usage;
    }

    public final CertificateStatusType status() {
        return CertificateStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant activeDate() {
        return this.activeDate;
    }

    public final Instant inactiveDate() {
        return this.inactiveDate;
    }

    public final CertificateType type() {
        return CertificateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inactiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedCertificate)) {
            return false;
        }
        ListedCertificate other = (ListedCertificate)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.usageAsString(), other.usageAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.activeDate(), other.activeDate()) && Objects.equals(this.inactiveDate(), other.inactiveDate()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ListedCertificate").add("Arn", (Object)this.arn()).add("CertificateId", (Object)this.certificateId()).add("Usage", (Object)this.usageAsString()).add("Status", (Object)this.statusAsString()).add("ActiveDate", (Object)this.activeDate()).add("InactiveDate", (Object)this.inactiveDate()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "Usage": {
                return Optional.ofNullable(clazz.cast(this.usageAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ActiveDate": {
                return Optional.ofNullable(clazz.cast(this.activeDate()));
            }
            case "InactiveDate": {
                return Optional.ofNullable(clazz.cast(this.inactiveDate()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedCertificate, T> g) {
        return obj -> g.apply((ListedCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String certificateId;
        private String usage;
        private String status;
        private Instant activeDate;
        private Instant inactiveDate;
        private String type;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedCertificate model) {
            this.arn(model.arn);
            this.certificateId(model.certificateId);
            this.usage(model.usage);
            this.status(model.status);
            this.activeDate(model.activeDate);
            this.inactiveDate(model.inactiveDate);
            this.type(model.type);
            this.description(model.description);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getUsage() {
            return this.usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public final Builder usage(CertificateUsageType usage) {
            this.usage(usage == null ? null : usage.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getActiveDate() {
            return this.activeDate;
        }

        public final void setActiveDate(Instant activeDate) {
            this.activeDate = activeDate;
        }

        @Override
        public final Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Instant getInactiveDate() {
            return this.inactiveDate;
        }

        public final void setInactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
        }

        @Override
        public final Builder inactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ListedCertificate build() {
            return new ListedCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedCertificate> {
        public Builder arn(String var1);

        public Builder certificateId(String var1);

        public Builder usage(String var1);

        public Builder usage(CertificateUsageType var1);

        public Builder status(String var1);

        public Builder status(CertificateStatusType var1);

        public Builder activeDate(Instant var1);

        public Builder inactiveDate(Instant var1);

        public Builder type(String var1);

        public Builder type(CertificateType var1);

        public Builder description(String var1);
    }
}

