/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.model.ListAccessesRequest;
import software.amazon.awssdk.services.transfer.model.ListAccessesResponse;

public class ListAccessesPublisher
implements SdkPublisher<ListAccessesResponse> {
    private final TransferAsyncClient client;
    private final ListAccessesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessesPublisher(TransferAsyncClient client, ListAccessesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessesPublisher(TransferAsyncClient client, ListAccessesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAccessesResponseFetcher
    implements AsyncPageFetcher<ListAccessesResponse> {
        private ListAccessesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessesResponse> nextPage(ListAccessesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessesPublisher.this.client.listAccesses(ListAccessesPublisher.this.firstRequest);
            }
            return ListAccessesPublisher.this.client.listAccesses((ListAccessesRequest)((Object)ListAccessesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

