/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.model.ListExecutionsRequest;
import software.amazon.awssdk.services.transfer.model.ListExecutionsResponse;

public class ListExecutionsPublisher
implements SdkPublisher<ListExecutionsResponse> {
    private final TransferAsyncClient client;
    private final ListExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExecutionsPublisher(TransferAsyncClient client, ListExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExecutionsPublisher(TransferAsyncClient client, ListExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExecutionsResponseFetcher
    implements AsyncPageFetcher<ListExecutionsResponse> {
        private ListExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExecutionsResponse> nextPage(ListExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListExecutionsPublisher.this.client.listExecutions(ListExecutionsPublisher.this.firstRequest);
            }
            return ListExecutionsPublisher.this.client.listExecutions((ListExecutionsRequest)((Object)ListExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

