/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.model.AccessDeniedException;
import software.amazon.awssdk.services.transfer.model.ConflictException;
import software.amazon.awssdk.services.transfer.model.CreateServerRequest;
import software.amazon.awssdk.services.transfer.model.CreateServerResponse;
import software.amazon.awssdk.services.transfer.model.CreateUserRequest;
import software.amazon.awssdk.services.transfer.model.CreateUserResponse;
import software.amazon.awssdk.services.transfer.model.DeleteServerRequest;
import software.amazon.awssdk.services.transfer.model.DeleteServerResponse;
import software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyRequest;
import software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyResponse;
import software.amazon.awssdk.services.transfer.model.DeleteUserRequest;
import software.amazon.awssdk.services.transfer.model.DeleteUserResponse;
import software.amazon.awssdk.services.transfer.model.DescribeServerRequest;
import software.amazon.awssdk.services.transfer.model.DescribeServerResponse;
import software.amazon.awssdk.services.transfer.model.DescribeUserRequest;
import software.amazon.awssdk.services.transfer.model.DescribeUserResponse;
import software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest;
import software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse;
import software.amazon.awssdk.services.transfer.model.InternalServiceErrorException;
import software.amazon.awssdk.services.transfer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.transfer.model.InvalidRequestException;
import software.amazon.awssdk.services.transfer.model.ListServersRequest;
import software.amazon.awssdk.services.transfer.model.ListServersResponse;
import software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.transfer.model.ListUsersRequest;
import software.amazon.awssdk.services.transfer.model.ListUsersResponse;
import software.amazon.awssdk.services.transfer.model.ResourceExistsException;
import software.amazon.awssdk.services.transfer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.transfer.model.ServiceUnavailableException;
import software.amazon.awssdk.services.transfer.model.StartServerRequest;
import software.amazon.awssdk.services.transfer.model.StartServerResponse;
import software.amazon.awssdk.services.transfer.model.StopServerRequest;
import software.amazon.awssdk.services.transfer.model.StopServerResponse;
import software.amazon.awssdk.services.transfer.model.TagResourceRequest;
import software.amazon.awssdk.services.transfer.model.TagResourceResponse;
import software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest;
import software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse;
import software.amazon.awssdk.services.transfer.model.ThrottlingException;
import software.amazon.awssdk.services.transfer.model.TransferException;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.services.transfer.model.UntagResourceRequest;
import software.amazon.awssdk.services.transfer.model.UntagResourceResponse;
import software.amazon.awssdk.services.transfer.model.UpdateServerRequest;
import software.amazon.awssdk.services.transfer.model.UpdateServerResponse;
import software.amazon.awssdk.services.transfer.model.UpdateUserRequest;
import software.amazon.awssdk.services.transfer.model.UpdateUserResponse;
import software.amazon.awssdk.services.transfer.paginators.ListServersIterable;
import software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.transfer.paginators.ListUsersIterable;
import software.amazon.awssdk.services.transfer.transform.CreateServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DeleteServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DeleteSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DescribeServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ImportSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListServersRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.StartServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.StopServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.TestIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.UpdateServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.UpdateUserRequestMarshaller;

@SdkInternalApi
final class DefaultTransferClient
implements TransferClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTransferClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "transfer";
    }

    @Override
    public CreateServerResponse createServer(CreateServerRequest createServerRequest) throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServerRequest).withMarshaller((Marshaller)new CreateServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserRequest).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteServerResponse deleteServer(DeleteServerRequest deleteServerRequest) throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServerRequest).withMarshaller((Marshaller)new DeleteServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteSshPublicKeyResponse deleteSshPublicKey(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSshPublicKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteSshPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSshPublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSshPublicKeyRequest).withMarshaller((Marshaller)new DeleteSshPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeServerResponse describeServer(DescribeServerRequest describeServerRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServerRequest).withMarshaller((Marshaller)new DescribeServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserRequest).withMarshaller((Marshaller)new DescribeUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ImportSshPublicKeyResponse importSshPublicKey(ImportSshPublicKeyRequest importSshPublicKeyRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportSshPublicKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ImportSshPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportSshPublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importSshPublicKeyRequest).withMarshaller((Marshaller)new ImportSshPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListServersResponse listServers(ListServersRequest listServersRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServersRequest).withMarshaller((Marshaller)new ListServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListServersIterable listServersPaginator(ListServersRequest listServersRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return new ListServersIterable(this, this.applyPaginatorUserAgent(listServersRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersRequest).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return new ListUsersIterable(this, this.applyPaginatorUserAgent(listUsersRequest));
    }

    @Override
    public StartServerResponse startServer(StartServerRequest startServerRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startServerRequest).withMarshaller((Marshaller)new StartServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopServerResponse stopServer(StopServerRequest stopServerRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopServerRequest).withMarshaller((Marshaller)new StopServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TestIdentityProviderResponse testIdentityProvider(TestIdentityProviderRequest testIdentityProviderRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestIdentityProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TestIdentityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestIdentityProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testIdentityProviderRequest).withMarshaller((Marshaller)new TestIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateServerResponse updateServer(UpdateServerRequest updateServerRequest) throws AccessDeniedException, ServiceUnavailableException, ConflictException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServerRequest).withMarshaller((Marshaller)new UpdateServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserRequest).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TransferException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceError").exceptionBuilderSupplier(InternalServiceErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceExistsException").exceptionBuilderSupplier(ResourceExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends TransferRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.31").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TransferRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

