/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinitionsCopier;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeEncryptionSettings;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeLanguageCode;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeMediaEncoding;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribePostStreamAnalyticsResult;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribePostStreamAnalyticsSettings;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeStreamStatus;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeVocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalScribeStreamDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeStreamDetails> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::sessionId)).setter(MedicalScribeStreamDetails.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<Instant> STREAM_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StreamCreatedAt").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::streamCreatedAt)).setter(MedicalScribeStreamDetails.setter(Builder::streamCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreatedAt").build()}).build();
    private static final SdkField<Instant> STREAM_ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StreamEndedAt").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::streamEndedAt)).setter(MedicalScribeStreamDetails.setter(Builder::streamEndedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamEndedAt").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::languageCodeAsString)).setter(MedicalScribeStreamDetails.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::mediaSampleRateHertz)).setter(MedicalScribeStreamDetails.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build()}).build();
    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaEncoding").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::mediaEncodingAsString)).setter(MedicalScribeStreamDetails.setter(Builder::mediaEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaEncoding").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::vocabularyName)).setter(MedicalScribeStreamDetails.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::vocabularyFilterName)).setter(MedicalScribeStreamDetails.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::vocabularyFilterMethodAsString)).setter(MedicalScribeStreamDetails.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceAccessRoleArn").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::resourceAccessRoleArn)).setter(MedicalScribeStreamDetails.setter(Builder::resourceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build()}).build();
    private static final SdkField<List<MedicalScribeChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelDefinitions").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::channelDefinitions)).setter(MedicalScribeStreamDetails.setter(Builder::channelDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalScribeChannelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MedicalScribeEncryptionSettings> ENCRYPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionSettings").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::encryptionSettings)).setter(MedicalScribeStreamDetails.setter(Builder::encryptionSettings)).constructor(MedicalScribeEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionSettings").build()}).build();
    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamStatus").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::streamStatusAsString)).setter(MedicalScribeStreamDetails.setter(Builder::streamStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamStatus").build()}).build();
    private static final SdkField<MedicalScribePostStreamAnalyticsSettings> POST_STREAM_ANALYTICS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostStreamAnalyticsSettings").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::postStreamAnalyticsSettings)).setter(MedicalScribeStreamDetails.setter(Builder::postStreamAnalyticsSettings)).constructor(MedicalScribePostStreamAnalyticsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostStreamAnalyticsSettings").build()}).build();
    private static final SdkField<MedicalScribePostStreamAnalyticsResult> POST_STREAM_ANALYTICS_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostStreamAnalyticsResult").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::postStreamAnalyticsResult)).setter(MedicalScribeStreamDetails.setter(Builder::postStreamAnalyticsResult)).constructor(MedicalScribePostStreamAnalyticsResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostStreamAnalyticsResult").build()}).build();
    private static final SdkField<Boolean> MEDICAL_SCRIBE_CONTEXT_PROVIDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MedicalScribeContextProvided").getter(MedicalScribeStreamDetails.getter(MedicalScribeStreamDetails::medicalScribeContextProvided)).setter(MedicalScribeStreamDetails.setter(Builder::medicalScribeContextProvided)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeContextProvided").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, STREAM_CREATED_AT_FIELD, STREAM_ENDED_AT_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, RESOURCE_ACCESS_ROLE_ARN_FIELD, CHANNEL_DEFINITIONS_FIELD, ENCRYPTION_SETTINGS_FIELD, STREAM_STATUS_FIELD, POST_STREAM_ANALYTICS_SETTINGS_FIELD, POST_STREAM_ANALYTICS_RESULT_FIELD, MEDICAL_SCRIBE_CONTEXT_PROVIDED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MedicalScribeStreamDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final Instant streamCreatedAt;
    private final Instant streamEndedAt;
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaEncoding;
    private final String vocabularyName;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;
    private final String resourceAccessRoleArn;
    private final List<MedicalScribeChannelDefinition> channelDefinitions;
    private final MedicalScribeEncryptionSettings encryptionSettings;
    private final String streamStatus;
    private final MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings;
    private final MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult;
    private final Boolean medicalScribeContextProvided;

    private MedicalScribeStreamDetails(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.streamCreatedAt = builder.streamCreatedAt;
        this.streamEndedAt = builder.streamEndedAt;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.channelDefinitions = builder.channelDefinitions;
        this.encryptionSettings = builder.encryptionSettings;
        this.streamStatus = builder.streamStatus;
        this.postStreamAnalyticsSettings = builder.postStreamAnalyticsSettings;
        this.postStreamAnalyticsResult = builder.postStreamAnalyticsResult;
        this.medicalScribeContextProvided = builder.medicalScribeContextProvided;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant streamCreatedAt() {
        return this.streamCreatedAt;
    }

    public final Instant streamEndedAt() {
        return this.streamEndedAt;
    }

    public final MedicalScribeLanguageCode languageCode() {
        return MedicalScribeLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public final MedicalScribeMediaEncoding mediaEncoding() {
        return MedicalScribeMediaEncoding.fromValue(this.mediaEncoding);
    }

    public final String mediaEncodingAsString() {
        return this.mediaEncoding;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final MedicalScribeVocabularyFilterMethod vocabularyFilterMethod() {
        return MedicalScribeVocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final String resourceAccessRoleArn() {
        return this.resourceAccessRoleArn;
    }

    public final boolean hasChannelDefinitions() {
        return this.channelDefinitions != null && !(this.channelDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MedicalScribeChannelDefinition> channelDefinitions() {
        return this.channelDefinitions;
    }

    public final MedicalScribeEncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public final MedicalScribeStreamStatus streamStatus() {
        return MedicalScribeStreamStatus.fromValue(this.streamStatus);
    }

    public final String streamStatusAsString() {
        return this.streamStatus;
    }

    public final MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings() {
        return this.postStreamAnalyticsSettings;
    }

    public final MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult() {
        return this.postStreamAnalyticsResult;
    }

    public final Boolean medicalScribeContextProvided() {
        return this.medicalScribeContextProvided;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamEndedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelDefinitions() ? this.channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.postStreamAnalyticsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.postStreamAnalyticsResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeContextProvided());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeStreamDetails)) {
            return false;
        }
        MedicalScribeStreamDetails other = (MedicalScribeStreamDetails)obj;
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.streamCreatedAt(), other.streamCreatedAt()) && Objects.equals(this.streamEndedAt(), other.streamEndedAt()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaEncodingAsString(), other.mediaEncodingAsString()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.resourceAccessRoleArn(), other.resourceAccessRoleArn()) && this.hasChannelDefinitions() == other.hasChannelDefinitions() && Objects.equals(this.channelDefinitions(), other.channelDefinitions()) && Objects.equals(this.encryptionSettings(), other.encryptionSettings()) && Objects.equals(this.streamStatusAsString(), other.streamStatusAsString()) && Objects.equals(this.postStreamAnalyticsSettings(), other.postStreamAnalyticsSettings()) && Objects.equals(this.postStreamAnalyticsResult(), other.postStreamAnalyticsResult()) && Objects.equals(this.medicalScribeContextProvided(), other.medicalScribeContextProvided());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeStreamDetails").add("SessionId", (Object)this.sessionId()).add("StreamCreatedAt", (Object)this.streamCreatedAt()).add("StreamEndedAt", (Object)this.streamEndedAt()).add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaEncoding", (Object)this.mediaEncodingAsString()).add("VocabularyName", (Object)this.vocabularyName()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("ResourceAccessRoleArn", (Object)this.resourceAccessRoleArn()).add("ChannelDefinitions", this.hasChannelDefinitions() ? this.channelDefinitions() : null).add("EncryptionSettings", (Object)this.encryptionSettings()).add("StreamStatus", (Object)this.streamStatusAsString()).add("PostStreamAnalyticsSettings", (Object)this.postStreamAnalyticsSettings()).add("PostStreamAnalyticsResult", (Object)this.postStreamAnalyticsResult()).add("MedicalScribeContextProvided", (Object)this.medicalScribeContextProvided()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "StreamCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.streamCreatedAt()));
            }
            case "StreamEndedAt": {
                return Optional.ofNullable(clazz.cast(this.streamEndedAt()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaEncoding": {
                return Optional.ofNullable(clazz.cast(this.mediaEncodingAsString()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "ResourceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessRoleArn()));
            }
            case "ChannelDefinitions": {
                return Optional.ofNullable(clazz.cast(this.channelDefinitions()));
            }
            case "EncryptionSettings": {
                return Optional.ofNullable(clazz.cast(this.encryptionSettings()));
            }
            case "StreamStatus": {
                return Optional.ofNullable(clazz.cast(this.streamStatusAsString()));
            }
            case "PostStreamAnalyticsSettings": {
                return Optional.ofNullable(clazz.cast(this.postStreamAnalyticsSettings()));
            }
            case "PostStreamAnalyticsResult": {
                return Optional.ofNullable(clazz.cast(this.postStreamAnalyticsResult()));
            }
            case "MedicalScribeContextProvided": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeContextProvided()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("StreamCreatedAt", STREAM_CREATED_AT_FIELD);
        map.put("StreamEndedAt", STREAM_ENDED_AT_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("MediaSampleRateHertz", MEDIA_SAMPLE_RATE_HERTZ_FIELD);
        map.put("MediaEncoding", MEDIA_ENCODING_FIELD);
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
        map.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
        map.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        map.put("EncryptionSettings", ENCRYPTION_SETTINGS_FIELD);
        map.put("StreamStatus", STREAM_STATUS_FIELD);
        map.put("PostStreamAnalyticsSettings", POST_STREAM_ANALYTICS_SETTINGS_FIELD);
        map.put("PostStreamAnalyticsResult", POST_STREAM_ANALYTICS_RESULT_FIELD);
        map.put("MedicalScribeContextProvided", MEDICAL_SCRIBE_CONTEXT_PROVIDED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeStreamDetails, T> g) {
        return obj -> g.apply((MedicalScribeStreamDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionId;
        private Instant streamCreatedAt;
        private Instant streamEndedAt;
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaEncoding;
        private String vocabularyName;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;
        private String resourceAccessRoleArn;
        private List<MedicalScribeChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();
        private MedicalScribeEncryptionSettings encryptionSettings;
        private String streamStatus;
        private MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings;
        private MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult;
        private Boolean medicalScribeContextProvided;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeStreamDetails model) {
            this.sessionId(model.sessionId);
            this.streamCreatedAt(model.streamCreatedAt);
            this.streamEndedAt(model.streamEndedAt);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaEncoding(model.mediaEncoding);
            this.vocabularyName(model.vocabularyName);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.resourceAccessRoleArn(model.resourceAccessRoleArn);
            this.channelDefinitions(model.channelDefinitions);
            this.encryptionSettings(model.encryptionSettings);
            this.streamStatus(model.streamStatus);
            this.postStreamAnalyticsSettings(model.postStreamAnalyticsSettings);
            this.postStreamAnalyticsResult(model.postStreamAnalyticsResult);
            this.medicalScribeContextProvided(model.medicalScribeContextProvided);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getStreamCreatedAt() {
            return this.streamCreatedAt;
        }

        public final void setStreamCreatedAt(Instant streamCreatedAt) {
            this.streamCreatedAt = streamCreatedAt;
        }

        @Override
        public final Builder streamCreatedAt(Instant streamCreatedAt) {
            this.streamCreatedAt = streamCreatedAt;
            return this;
        }

        public final Instant getStreamEndedAt() {
            return this.streamEndedAt;
        }

        public final void setStreamEndedAt(Instant streamEndedAt) {
            this.streamEndedAt = streamEndedAt;
        }

        @Override
        public final Builder streamEndedAt(Instant streamEndedAt) {
            this.streamEndedAt = streamEndedAt;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(MedicalScribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return this.mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MedicalScribeMediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(MedicalScribeVocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return this.resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final List<MedicalScribeChannelDefinition.Builder> getChannelDefinitions() {
            List<MedicalScribeChannelDefinition.Builder> result = MedicalScribeChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<MedicalScribeChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(MedicalScribeChannelDefinition ... channelDefinitions) {
            this.channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder> ... channelDefinitions) {
            this.channelDefinitions(Stream.of(channelDefinitions).map(c -> (MedicalScribeChannelDefinition)((MedicalScribeChannelDefinition.Builder)MedicalScribeChannelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MedicalScribeEncryptionSettings.Builder getEncryptionSettings() {
            return this.encryptionSettings != null ? this.encryptionSettings.toBuilder() : null;
        }

        public final void setEncryptionSettings(MedicalScribeEncryptionSettings.BuilderImpl encryptionSettings) {
            this.encryptionSettings = encryptionSettings != null ? encryptionSettings.build() : null;
        }

        @Override
        public final Builder encryptionSettings(MedicalScribeEncryptionSettings encryptionSettings) {
            this.encryptionSettings = encryptionSettings;
            return this;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(MedicalScribeStreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        public final MedicalScribePostStreamAnalyticsSettings.Builder getPostStreamAnalyticsSettings() {
            return this.postStreamAnalyticsSettings != null ? this.postStreamAnalyticsSettings.toBuilder() : null;
        }

        public final void setPostStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings.BuilderImpl postStreamAnalyticsSettings) {
            this.postStreamAnalyticsSettings = postStreamAnalyticsSettings != null ? postStreamAnalyticsSettings.build() : null;
        }

        @Override
        public final Builder postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings) {
            this.postStreamAnalyticsSettings = postStreamAnalyticsSettings;
            return this;
        }

        public final MedicalScribePostStreamAnalyticsResult.Builder getPostStreamAnalyticsResult() {
            return this.postStreamAnalyticsResult != null ? this.postStreamAnalyticsResult.toBuilder() : null;
        }

        public final void setPostStreamAnalyticsResult(MedicalScribePostStreamAnalyticsResult.BuilderImpl postStreamAnalyticsResult) {
            this.postStreamAnalyticsResult = postStreamAnalyticsResult != null ? postStreamAnalyticsResult.build() : null;
        }

        @Override
        public final Builder postStreamAnalyticsResult(MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult) {
            this.postStreamAnalyticsResult = postStreamAnalyticsResult;
            return this;
        }

        public final Boolean getMedicalScribeContextProvided() {
            return this.medicalScribeContextProvided;
        }

        public final void setMedicalScribeContextProvided(Boolean medicalScribeContextProvided) {
            this.medicalScribeContextProvided = medicalScribeContextProvided;
        }

        @Override
        public final Builder medicalScribeContextProvided(Boolean medicalScribeContextProvided) {
            this.medicalScribeContextProvided = medicalScribeContextProvided;
            return this;
        }

        public MedicalScribeStreamDetails build() {
            return new MedicalScribeStreamDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeStreamDetails> {
        public Builder sessionId(String var1);

        public Builder streamCreatedAt(Instant var1);

        public Builder streamEndedAt(Instant var1);

        public Builder languageCode(String var1);

        public Builder languageCode(MedicalScribeLanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaEncoding(String var1);

        public Builder mediaEncoding(MedicalScribeMediaEncoding var1);

        public Builder vocabularyName(String var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(MedicalScribeVocabularyFilterMethod var1);

        public Builder resourceAccessRoleArn(String var1);

        public Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> var1);

        public Builder channelDefinitions(MedicalScribeChannelDefinition ... var1);

        public Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder> ... var1);

        public Builder encryptionSettings(MedicalScribeEncryptionSettings var1);

        default public Builder encryptionSettings(Consumer<MedicalScribeEncryptionSettings.Builder> encryptionSettings) {
            return this.encryptionSettings((MedicalScribeEncryptionSettings)((MedicalScribeEncryptionSettings.Builder)MedicalScribeEncryptionSettings.builder().applyMutation(encryptionSettings)).build());
        }

        public Builder streamStatus(String var1);

        public Builder streamStatus(MedicalScribeStreamStatus var1);

        public Builder postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings var1);

        default public Builder postStreamAnalyticsSettings(Consumer<MedicalScribePostStreamAnalyticsSettings.Builder> postStreamAnalyticsSettings) {
            return this.postStreamAnalyticsSettings((MedicalScribePostStreamAnalyticsSettings)((MedicalScribePostStreamAnalyticsSettings.Builder)MedicalScribePostStreamAnalyticsSettings.builder().applyMutation(postStreamAnalyticsSettings)).build());
        }

        public Builder postStreamAnalyticsResult(MedicalScribePostStreamAnalyticsResult var1);

        default public Builder postStreamAnalyticsResult(Consumer<MedicalScribePostStreamAnalyticsResult.Builder> postStreamAnalyticsResult) {
            return this.postStreamAnalyticsResult((MedicalScribePostStreamAnalyticsResult)((MedicalScribePostStreamAnalyticsResult.Builder)MedicalScribePostStreamAnalyticsResult.builder().applyMutation(postStreamAnalyticsResult)).build());
        }

        public Builder medicalScribeContextProvided(Boolean var1);
    }
}

