/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType;
import software.amazon.awssdk.services.transcribestreaming.model.ContentRedactionType;
import software.amazon.awssdk.services.transcribestreaming.model.LanguageCode;
import software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding;
import software.amazon.awssdk.services.transcribestreaming.model.PartialResultsStability;
import software.amazon.awssdk.services.transcribestreaming.model.TranscribeStreamingRequest;
import software.amazon.awssdk.services.transcribestreaming.model.VocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartStreamTranscriptionRequest
extends TranscribeStreamingRequest
implements ToCopyableBuilder<Builder, StartStreamTranscriptionRequest> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::languageCodeAsString)).setter(StartStreamTranscriptionRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::mediaSampleRateHertz)).setter(StartStreamTranscriptionRequest.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate").build()}).build();
    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaEncoding").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::mediaEncodingAsString)).setter(StartStreamTranscriptionRequest.setter(Builder::mediaEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::vocabularyName)).setter(StartStreamTranscriptionRequest.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-name").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::sessionId)).setter(StartStreamTranscriptionRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::vocabularyFilterName)).setter(StartStreamTranscriptionRequest.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-filter-name").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::vocabularyFilterMethodAsString)).setter(StartStreamTranscriptionRequest.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-filter-method").build()}).build();
    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowSpeakerLabel").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::showSpeakerLabel)).setter(StartStreamTranscriptionRequest.setter(Builder::showSpeakerLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-show-speaker-label").build()}).build();
    private static final SdkField<Boolean> ENABLE_CHANNEL_IDENTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableChannelIdentification").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::enableChannelIdentification)).setter(StartStreamTranscriptionRequest.setter(Builder::enableChannelIdentification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-enable-channel-identification").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfChannels").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::numberOfChannels)).setter(StartStreamTranscriptionRequest.setter(Builder::numberOfChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-number-of-channels").build()}).build();
    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePartialResultsStabilization").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::enablePartialResultsStabilization)).setter(StartStreamTranscriptionRequest.setter(Builder::enablePartialResultsStabilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-enable-partial-results-stabilization").build()}).build();
    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartialResultsStability").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::partialResultsStabilityAsString)).setter(StartStreamTranscriptionRequest.setter(Builder::partialResultsStability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-partial-results-stability").build()}).build();
    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentIdentificationType").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::contentIdentificationTypeAsString)).setter(StartStreamTranscriptionRequest.setter(Builder::contentIdentificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-content-identification-type").build()}).build();
    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentRedactionType").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::contentRedactionTypeAsString)).setter(StartStreamTranscriptionRequest.setter(Builder::contentRedactionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-content-redaction-type").build()}).build();
    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PiiEntityTypes").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::piiEntityTypes)).setter(StartStreamTranscriptionRequest.setter(Builder::piiEntityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-pii-entity-types").build()}).build();
    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageModelName").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::languageModelName)).setter(StartStreamTranscriptionRequest.setter(Builder::languageModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-model-name").build()}).build();
    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IdentifyLanguage").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::identifyLanguage)).setter(StartStreamTranscriptionRequest.setter(Builder::identifyLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-identify-language").build()}).build();
    private static final SdkField<String> LANGUAGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageOptions").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::languageOptions)).setter(StartStreamTranscriptionRequest.setter(Builder::languageOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-options").build()}).build();
    private static final SdkField<String> PREFERRED_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredLanguage").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::preferredLanguageAsString)).setter(StartStreamTranscriptionRequest.setter(Builder::preferredLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-preferred-language").build()}).build();
    private static final SdkField<String> VOCABULARY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyNames").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::vocabularyNames)).setter(StartStreamTranscriptionRequest.setter(Builder::vocabularyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-names").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterNames").getter(StartStreamTranscriptionRequest.getter(StartStreamTranscriptionRequest::vocabularyFilterNames)).setter(StartStreamTranscriptionRequest.setter(Builder::vocabularyFilterNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-filter-names").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, SESSION_ID_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, SHOW_SPEAKER_LABEL_FIELD, ENABLE_CHANNEL_IDENTIFICATION_FIELD, NUMBER_OF_CHANNELS_FIELD, ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD, PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, CONTENT_REDACTION_TYPE_FIELD, PII_ENTITY_TYPES_FIELD, LANGUAGE_MODEL_NAME_FIELD, IDENTIFY_LANGUAGE_FIELD, LANGUAGE_OPTIONS_FIELD, PREFERRED_LANGUAGE_FIELD, VOCABULARY_NAMES_FIELD, VOCABULARY_FILTER_NAMES_FIELD));
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaEncoding;
    private final String vocabularyName;
    private final String sessionId;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;
    private final Boolean showSpeakerLabel;
    private final Boolean enableChannelIdentification;
    private final Integer numberOfChannels;
    private final Boolean enablePartialResultsStabilization;
    private final String partialResultsStability;
    private final String contentIdentificationType;
    private final String contentRedactionType;
    private final String piiEntityTypes;
    private final String languageModelName;
    private final Boolean identifyLanguage;
    private final String languageOptions;
    private final String preferredLanguage;
    private final String vocabularyNames;
    private final String vocabularyFilterNames;

    private StartStreamTranscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.sessionId = builder.sessionId;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.enableChannelIdentification = builder.enableChannelIdentification;
        this.numberOfChannels = builder.numberOfChannels;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.languageModelName = builder.languageModelName;
        this.identifyLanguage = builder.identifyLanguage;
        this.languageOptions = builder.languageOptions;
        this.preferredLanguage = builder.preferredLanguage;
        this.vocabularyNames = builder.vocabularyNames;
        this.vocabularyFilterNames = builder.vocabularyFilterNames;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(this.mediaEncoding);
    }

    public final String mediaEncodingAsString() {
        return this.mediaEncoding;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final Boolean showSpeakerLabel() {
        return this.showSpeakerLabel;
    }

    public final Boolean enableChannelIdentification() {
        return this.enableChannelIdentification;
    }

    public final Integer numberOfChannels() {
        return this.numberOfChannels;
    }

    public final Boolean enablePartialResultsStabilization() {
        return this.enablePartialResultsStabilization;
    }

    public final PartialResultsStability partialResultsStability() {
        return PartialResultsStability.fromValue(this.partialResultsStability);
    }

    public final String partialResultsStabilityAsString() {
        return this.partialResultsStability;
    }

    public final ContentIdentificationType contentIdentificationType() {
        return ContentIdentificationType.fromValue(this.contentIdentificationType);
    }

    public final String contentIdentificationTypeAsString() {
        return this.contentIdentificationType;
    }

    public final ContentRedactionType contentRedactionType() {
        return ContentRedactionType.fromValue(this.contentRedactionType);
    }

    public final String contentRedactionTypeAsString() {
        return this.contentRedactionType;
    }

    public final String piiEntityTypes() {
        return this.piiEntityTypes;
    }

    public final String languageModelName() {
        return this.languageModelName;
    }

    public final Boolean identifyLanguage() {
        return this.identifyLanguage;
    }

    public final String languageOptions() {
        return this.languageOptions;
    }

    public final LanguageCode preferredLanguage() {
        return LanguageCode.fromValue(this.preferredLanguage);
    }

    public final String preferredLanguageAsString() {
        return this.preferredLanguage;
    }

    public final String vocabularyNames() {
        return this.vocabularyNames;
    }

    public final String vocabularyFilterNames() {
        return this.vocabularyFilterNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableChannelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfChannels());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterNames());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamTranscriptionRequest)) {
            return false;
        }
        StartStreamTranscriptionRequest other = (StartStreamTranscriptionRequest)((Object)obj);
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaEncodingAsString(), other.mediaEncodingAsString()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.showSpeakerLabel(), other.showSpeakerLabel()) && Objects.equals(this.enableChannelIdentification(), other.enableChannelIdentification()) && Objects.equals(this.numberOfChannels(), other.numberOfChannels()) && Objects.equals(this.enablePartialResultsStabilization(), other.enablePartialResultsStabilization()) && Objects.equals(this.partialResultsStabilityAsString(), other.partialResultsStabilityAsString()) && Objects.equals(this.contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString()) && Objects.equals(this.contentRedactionTypeAsString(), other.contentRedactionTypeAsString()) && Objects.equals(this.piiEntityTypes(), other.piiEntityTypes()) && Objects.equals(this.languageModelName(), other.languageModelName()) && Objects.equals(this.identifyLanguage(), other.identifyLanguage()) && Objects.equals(this.languageOptions(), other.languageOptions()) && Objects.equals(this.preferredLanguageAsString(), other.preferredLanguageAsString()) && Objects.equals(this.vocabularyNames(), other.vocabularyNames()) && Objects.equals(this.vocabularyFilterNames(), other.vocabularyFilterNames());
    }

    public final String toString() {
        return ToString.builder((String)"StartStreamTranscriptionRequest").add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaEncoding", (Object)this.mediaEncodingAsString()).add("VocabularyName", (Object)this.vocabularyName()).add("SessionId", (Object)this.sessionId()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("ShowSpeakerLabel", (Object)this.showSpeakerLabel()).add("EnableChannelIdentification", (Object)this.enableChannelIdentification()).add("NumberOfChannels", (Object)this.numberOfChannels()).add("EnablePartialResultsStabilization", (Object)this.enablePartialResultsStabilization()).add("PartialResultsStability", (Object)this.partialResultsStabilityAsString()).add("ContentIdentificationType", (Object)this.contentIdentificationTypeAsString()).add("ContentRedactionType", (Object)this.contentRedactionTypeAsString()).add("PiiEntityTypes", (Object)this.piiEntityTypes()).add("LanguageModelName", (Object)this.languageModelName()).add("IdentifyLanguage", (Object)this.identifyLanguage()).add("LanguageOptions", (Object)this.languageOptions()).add("PreferredLanguage", (Object)this.preferredLanguageAsString()).add("VocabularyNames", (Object)this.vocabularyNames()).add("VocabularyFilterNames", (Object)this.vocabularyFilterNames()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaEncoding": {
                return Optional.ofNullable(clazz.cast(this.mediaEncodingAsString()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "ShowSpeakerLabel": {
                return Optional.ofNullable(clazz.cast(this.showSpeakerLabel()));
            }
            case "EnableChannelIdentification": {
                return Optional.ofNullable(clazz.cast(this.enableChannelIdentification()));
            }
            case "NumberOfChannels": {
                return Optional.ofNullable(clazz.cast(this.numberOfChannels()));
            }
            case "EnablePartialResultsStabilization": {
                return Optional.ofNullable(clazz.cast(this.enablePartialResultsStabilization()));
            }
            case "PartialResultsStability": {
                return Optional.ofNullable(clazz.cast(this.partialResultsStabilityAsString()));
            }
            case "ContentIdentificationType": {
                return Optional.ofNullable(clazz.cast(this.contentIdentificationTypeAsString()));
            }
            case "ContentRedactionType": {
                return Optional.ofNullable(clazz.cast(this.contentRedactionTypeAsString()));
            }
            case "PiiEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.piiEntityTypes()));
            }
            case "LanguageModelName": {
                return Optional.ofNullable(clazz.cast(this.languageModelName()));
            }
            case "IdentifyLanguage": {
                return Optional.ofNullable(clazz.cast(this.identifyLanguage()));
            }
            case "LanguageOptions": {
                return Optional.ofNullable(clazz.cast(this.languageOptions()));
            }
            case "PreferredLanguage": {
                return Optional.ofNullable(clazz.cast(this.preferredLanguageAsString()));
            }
            case "VocabularyNames": {
                return Optional.ofNullable(clazz.cast(this.vocabularyNames()));
            }
            case "VocabularyFilterNames": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartStreamTranscriptionRequest, T> g) {
        return obj -> g.apply((StartStreamTranscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeStreamingRequest.BuilderImpl
    implements Builder {
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaEncoding;
        private String vocabularyName;
        private String sessionId;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;
        private Boolean showSpeakerLabel;
        private Boolean enableChannelIdentification;
        private Integer numberOfChannels;
        private Boolean enablePartialResultsStabilization;
        private String partialResultsStability;
        private String contentIdentificationType;
        private String contentRedactionType;
        private String piiEntityTypes;
        private String languageModelName;
        private Boolean identifyLanguage;
        private String languageOptions;
        private String preferredLanguage;
        private String vocabularyNames;
        private String vocabularyFilterNames;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamTranscriptionRequest model) {
            super(model);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaEncoding(model.mediaEncoding);
            this.vocabularyName(model.vocabularyName);
            this.sessionId(model.sessionId);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.showSpeakerLabel(model.showSpeakerLabel);
            this.enableChannelIdentification(model.enableChannelIdentification);
            this.numberOfChannels(model.numberOfChannels);
            this.enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            this.partialResultsStability(model.partialResultsStability);
            this.contentIdentificationType(model.contentIdentificationType);
            this.contentRedactionType(model.contentRedactionType);
            this.piiEntityTypes(model.piiEntityTypes);
            this.languageModelName(model.languageModelName);
            this.identifyLanguage(model.identifyLanguage);
            this.languageOptions(model.languageOptions);
            this.preferredLanguage(model.preferredLanguage);
            this.vocabularyNames(model.vocabularyNames);
            this.vocabularyFilterNames(model.vocabularyFilterNames);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        @Transient
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return this.mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        @Transient
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        @Transient
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final Boolean getShowSpeakerLabel() {
            return this.showSpeakerLabel;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        @Override
        @Transient
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final Boolean getEnableChannelIdentification() {
            return this.enableChannelIdentification;
        }

        public final void setEnableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
        }

        @Override
        @Transient
        public final Builder enableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
            return this;
        }

        public final Integer getNumberOfChannels() {
            return this.numberOfChannels;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        @Transient
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return this.enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        @Transient
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return this.partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        @Transient
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        @Transient
        public final Builder partialResultsStability(PartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return this.contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(ContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return this.contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        @Transient
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentRedactionType(ContentRedactionType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return this.piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        @Transient
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final String getLanguageModelName() {
            return this.languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        @Transient
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final Boolean getIdentifyLanguage() {
            return this.identifyLanguage;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        @Override
        @Transient
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final String getLanguageOptions() {
            return this.languageOptions;
        }

        public final void setLanguageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
        }

        @Override
        @Transient
        public final Builder languageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
            return this;
        }

        public final String getPreferredLanguage() {
            return this.preferredLanguage;
        }

        public final void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Override
        @Transient
        public final Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        @Override
        @Transient
        public final Builder preferredLanguage(LanguageCode preferredLanguage) {
            this.preferredLanguage(preferredLanguage == null ? null : preferredLanguage.toString());
            return this;
        }

        public final String getVocabularyNames() {
            return this.vocabularyNames;
        }

        public final void setVocabularyNames(String vocabularyNames) {
            this.vocabularyNames = vocabularyNames;
        }

        @Override
        @Transient
        public final Builder vocabularyNames(String vocabularyNames) {
            this.vocabularyNames = vocabularyNames;
            return this;
        }

        public final String getVocabularyFilterNames() {
            return this.vocabularyFilterNames;
        }

        public final void setVocabularyFilterNames(String vocabularyFilterNames) {
            this.vocabularyFilterNames = vocabularyFilterNames;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterNames(String vocabularyFilterNames) {
            this.vocabularyFilterNames = vocabularyFilterNames;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartStreamTranscriptionRequest build() {
            return new StartStreamTranscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeStreamingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartStreamTranscriptionRequest> {
        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaEncoding(String var1);

        public Builder mediaEncoding(MediaEncoding var1);

        public Builder vocabularyName(String var1);

        public Builder sessionId(String var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(VocabularyFilterMethod var1);

        public Builder showSpeakerLabel(Boolean var1);

        public Builder enableChannelIdentification(Boolean var1);

        public Builder numberOfChannels(Integer var1);

        public Builder enablePartialResultsStabilization(Boolean var1);

        public Builder partialResultsStability(String var1);

        public Builder partialResultsStability(PartialResultsStability var1);

        public Builder contentIdentificationType(String var1);

        public Builder contentIdentificationType(ContentIdentificationType var1);

        public Builder contentRedactionType(String var1);

        public Builder contentRedactionType(ContentRedactionType var1);

        public Builder piiEntityTypes(String var1);

        public Builder languageModelName(String var1);

        public Builder identifyLanguage(Boolean var1);

        public Builder languageOptions(String var1);

        public Builder preferredLanguage(String var1);

        public Builder preferredLanguage(LanguageCode var1);

        public Builder vocabularyNames(String var1);

        public Builder vocabularyFilterNames(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

