/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MediaEncoding {
    PCM("pcm"),
    OGG_OPUS("ogg-opus"),
    FLAC("flac"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MediaEncoding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MediaEncoding.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaEncoding> knownValues() {
        return Stream.of(MediaEncoding.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

